/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.treeg.ast;

import de.firemage.autograder.treeg.TreePrinter;
import de.firemage.autograder.treeg.ast.RegExNode;

public record PredefinedCharacterClass(Type type) implements RegExNode
{
    @Override
    public String toRegEx() {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.ANY -> ".";
            case Type.DIGIT -> "\\d";
            case Type.NON_DIGIT -> "\\D";
            case Type.HORIZONTAL_WHITESPACE -> "\\h";
            case Type.NON_HORIZONTAL_WHITESPACE -> "\\H";
            case Type.WHITESPACE -> "\\s";
            case Type.NON_WHITESPACE -> "\\S";
            case Type.VERTICAL_WHITESPACE -> "\\v";
            case Type.NON_VERTICAL_WHITESPACE -> "\\V";
            case Type.WORD -> "\\w";
            case Type.NON_WORD -> "\\W";
        };
    }

    @Override
    public void toTree(TreePrinter printer) {
        printer.addLine("Predefined Character Class (" + this.type + ")");
    }

    public static enum Type {
        ANY,
        DIGIT,
        NON_DIGIT,
        HORIZONTAL_WHITESPACE,
        NON_HORIZONTAL_WHITESPACE,
        WHITESPACE,
        NON_WHITESPACE,
        VERTICAL_WHITESPACE,
        NON_VERTICAL_WHITESPACE,
        WORD,
        NON_WORD;

    }
}

