/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.span;

import com.google.common.collect.Streams;
import de.firemage.autograder.span.Line;
import de.firemage.autograder.span.Span;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public record Text(String text, Span span) {
    public static Text fromString(int lineNumber, String text) {
        return new Text(text, Span.of(lineNumber, text));
    }

    public List<Line> lines() {
        int lineNumber = this.span.start().line();
        return Streams.zip(Stream.iterate(lineNumber, i -> i + 1), this.text.lines(), Line::new).collect(Collectors.toList());
    }

    public boolean isEmpty() {
        return this.text.isEmpty();
    }

    public Text subText(Span span) {
        return new Text(this.text.substring(span.start().offset(this.text), span.end().offset(this.text)), span);
    }

    public int lineNumberWidth() {
        int startLine = this.span.start().line() + 1;
        int endLine = this.span.end().line() + 1;
        return Math.max(Math.max(Text.stringLength(startLine), Text.stringLength(endLine)), 2);
    }

    private static int stringLength(int number) {
        return String.valueOf(number).length();
    }
}

