/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.span;

import de.firemage.autograder.span.Position;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;

public record Span(Position start, Position end) {
    public static Span of(int lineNumber, String string) {
        Position start = new Position(lineNumber, 0);
        String[] lines = string.split("\\R", -1);
        Position end = new Position(lineNumber + lines.length - 1, lines[lines.length - 1].length());
        return new Span(start, end);
    }

    public boolean isInline() {
        return this.start.line() == this.end.line();
    }

    public boolean includesLine(int lineNumber) {
        if (this.end.column() == 0) {
            return this.start.line() <= lineNumber && lineNumber < this.end.line();
        }
        return this.start.line() <= lineNumber && lineNumber <= this.end.line();
    }

    public boolean isEmpty() {
        return this.start.compareTo(this.end) >= 0;
    }

    private Span empty() {
        return new Span(this.start, this.start);
    }

    public boolean isFollowedBy(Span other) {
        return this.end().equals(other.start());
    }

    public boolean contains(Span span) {
        return this.intersection(span).map(span::equals).orElse(false);
    }

    public Span relativize(Span span) {
        if (!this.contains(span)) {
            throw new IllegalArgumentException("Span must be contained in this span");
        }
        Position start = new Position(span.start().line() - this.start().line(), span.start().column());
        Position end = new Position(span.end().line() - this.start().line(), span.end().column());
        return new Span(start, end);
    }

    public Optional<Span> intersection(Span other) {
        if (other.isEmpty()) {
            return Optional.of(other);
        }
        Position start = (Position)ObjectUtils.max((Comparable[])new Position[]{this.start(), other.start()});
        Position end = (Position)ObjectUtils.min((Comparable[])new Position[]{this.end(), other.end()});
        Span result = new Span(start, end);
        if (result.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(result);
    }

    public Span relativeIntersection(Span other) {
        return this.relativize(this.intersection(other).orElseGet(this::empty));
    }
}

