/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.span;

public record Position(int line, int column) implements Comparable<Position>
{
    public static Position fromOffset(int offset, CharSequence string) {
        int currentLine = 0;
        int currentLineStart = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\n') {
                ++currentLine;
                currentLineStart = i + 1;
            }
            if (i != offset) continue;
            return new Position(currentLine, i - currentLineStart);
        }
        throw new IllegalArgumentException("%d is not in text".formatted(offset));
    }

    public int offset(CharSequence string) {
        int currentLine = 0;
        int currentLineStart = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\n') {
                ++currentLine;
                currentLineStart = i + 1;
            }
            if (currentLine != this.line) continue;
            int result = currentLineStart + this.column;
            if (result > string.length()) {
                throw new IllegalArgumentException("%s is not in string".formatted(this));
            }
            return result;
        }
        throw new IllegalArgumentException("%s is not in string".formatted(this));
    }

    @Override
    public int compareTo(Position other) {
        int lineDiff = Integer.compare(this.line(), other.line());
        if (lineDiff != 0) {
            return lineDiff;
        }
        return Integer.compare(this.column(), other.column());
    }

    @Override
    public String toString() {
        return "Position(L%d:%d)".formatted(this.line(), this.column());
    }
}

