/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.span;

final class RenderState {
    private boolean isInMultiline;
    private final int lineNumberWidth;
    private int offset;

    RenderState(int offset, int lineNumberWidth) {
        this.offset = offset;
        this.lineNumberWidth = lineNumberWidth;
        this.isInMultiline = false;
    }

    int enterMultilineHighlight() {
        this.isInMultiline = true;
        this.offset = Math.max(this.offset - 2, 0);
        return this.offset;
    }

    int exitMultilineHighlight() {
        this.isInMultiline = false;
        this.offset += 2;
        return this.offset - 2;
    }

    boolean isInMultiline() {
        return this.isInMultiline;
    }

    int lineNumberWidth() {
        return this.lineNumberWidth;
    }

    int offset() {
        return this.offset;
    }
}

