/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.span;

import de.firemage.autograder.span.Span;
import de.firemage.autograder.span.Style;
import java.util.Optional;

public record Highlight(Span span, Optional<String> label, Style style) {
    public boolean isMultilineStart(int lineNumber) {
        return !this.span.isInline() && this.span.start().line() == lineNumber;
    }

    public boolean isMultilineEnd(int lineNumber) {
        return !this.span.isInline() && this.span.end().line() == lineNumber;
    }

    public Optional<String> render(int lineNumber) {
        if (!this.span.includesLine(lineNumber)) {
            return Optional.empty();
        }
        if (this.span.isInline()) {
            return Optional.of(this.renderInline(this.span.start().column(), this.span.end().column()));
        }
        if (this.isMultilineStart(lineNumber)) {
            String highlight = " %s%s".formatted("_".repeat(this.span.start().column()), this.style.marker());
            return Optional.of(highlight);
        }
        if (this.isMultilineEnd(lineNumber)) {
            String highlight = "|%s%s%s".formatted("_".repeat(this.span.end().column()), this.style.marker(), this.label.map(label -> " " + label).orElse(""));
            return Optional.of(highlight);
        }
        return Optional.empty();
    }

    private String renderInline(int start, int end) {
        return "%s%s%s".formatted(" ".repeat(start), this.style.marker().repeat(end - start), this.label.map(label -> " " + label).orElse(""));
    }

    public boolean isMultiline() {
        return !this.span.isInline();
    }
}

