/*
 * Decompiled with CFR 0.152.
 */
package de.firemage.autograder.executor;

import de.firemage.autograder.executor.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Scanner;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;

public class ConsoleExecutor {
    public void execute(String mainClass, String test, boolean quitOnFailure) throws IOException, InterruptedException {
        Iterator<String> lines = Arrays.stream(test.split("\n")).iterator();
        List<String> args = this.parseHeader(lines);
        if (this.executeTest(args, mainClass, lines, quitOnFailure)) {
            System.err.println("EXEC:  Test success");
        } else {
            System.err.println("EXEC:  Test failure");
        }
    }

    private List<String> parseHeader(Iterator<String> lines) {
        List<Object> args = null;
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("--")) {
                return args;
            }
            if (line.startsWith("name:")) {
                System.out.println("EXEC:  Running test " + line.substring(6));
                continue;
            }
            if (line.startsWith("comment:")) {
                System.out.println("EXEC:  " + line.substring(9));
                continue;
            }
            if (!line.startsWith("args:")) continue;
            if (line.length() <= 6) {
                args = List.of();
                continue;
            }
            args = List.of(line.substring(6).split(" "));
        }
        throw new IllegalStateException("Invalid test file: end of header missing");
    }

    private boolean executeTest(List<String> args, String mainClass, Iterator<String> lines, boolean quitOnFailure) throws IOException, InterruptedException {
        Process process = Util.startJVM(mainClass, args);
        OutputStream containerIn = process.getOutputStream();
        ConcurrentLinkedQueue<String> containerOut = new ConcurrentLinkedQueue<String>();
        Thread outThread = new Thread(new ProcessReader(containerOut, process.getInputStream()));
        outThread.setDaemon(true);
        outThread.start();
        boolean failed = false;
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("###")) continue;
            if (line.startsWith(">")) {
                this.pollAllOutput(containerOut);
                System.out.println("IN:    " + line.substring(1));
                containerIn.write(line.substring(1).getBytes());
                containerIn.write("\n".getBytes());
                containerIn.flush();
                continue;
            }
            String output = this.pollOutput(process, containerOut);
            if (output == null) {
                this.pollAllOutput(containerOut);
                System.err.println("EXEC:  The child JVM exited unexpectedly");
                System.exit(1);
            }
            if (this.matchOutput(output, line)) continue;
            failed = true;
            if (!quitOnFailure) continue;
            this.killVM(process);
            this.pollAllOutput(containerOut);
            return false;
        }
        if (!process.waitFor(5L, TimeUnit.SECONDS)) {
            System.err.println("EXEC:  The child JVM did not exit after 5s");
            this.killVM(process);
            this.pollAllOutput(containerOut);
            return false;
        }
        this.pollAllOutput(containerOut);
        System.out.println("EXEC:  Child JVM exited");
        if (process.exitValue() != 0) {
            System.err.println("EXEC:  The child JVM did not exit with exit code 0");
            return false;
        }
        return !failed;
    }

    private boolean matchOutput(String output, String line) {
        if (line.equals(output) || line.equals("!A!!R!^(E|e)rror.*") && (output.startsWith("Error") || output.startsWith("error"))) {
            return true;
        }
        System.err.println("EXEC:  Invalid output, got '" + output + "', expected '" + line + "' ");
        return false;
    }

    private String pollOutput(Process process, Queue<String> queue) throws InterruptedException {
        long beforeTime = System.currentTimeMillis();
        while (true) {
            if (!queue.isEmpty()) {
                String result = queue.poll();
                if (result.startsWith("AGENT")) {
                    System.out.println(result);
                    continue;
                }
                System.out.println("OUT:   " + result);
                return result;
            }
            if (System.currentTimeMillis() - beforeTime > 5000L) {
                System.err.println("EXEC:  Did not receive any output after 5s");
                System.exit(1);
            }
            if (!process.isAlive()) {
                return null;
            }
            Thread.sleep(10L);
        }
    }

    private void killVM(Process process) throws InterruptedException {
        process.destroy();
        if (!process.waitFor(5L, TimeUnit.SECONDS)) {
            process.destroyForcibly();
        }
    }

    private void pollAllOutput(Queue<String> containerOut) {
        while (!containerOut.isEmpty()) {
            System.out.println("OUT:   " + containerOut.poll());
        }
    }

    private static class ProcessReader
    implements Runnable {
        private final Scanner scanner;
        private final Queue<String> queue;

        private ProcessReader(Queue<String> queue, InputStream inputStream) {
            this.queue = queue;
            this.scanner = new Scanner(inputStream);
        }

        @Override
        public void run() {
            while (this.scanner.hasNextLine()) {
                this.queue.add(this.scanner.nextLine());
            }
        }
    }
}

