/*
 * Decompiled with CFR 0.152.
 */
package de.extrastandard.procedures.sa.acceptance;

import de.extra.client.starter.ExtraClient;
import de.extra.client.starter.ExtraClientTestBasic;
import de.extrastandard.api.model.execution.ICommunicationProtocol;
import de.extrastandard.api.model.execution.IPhaseConnection;
import de.extrastandard.api.model.execution.PersistentStatus;
import de.extrastandard.persistence.model.Execution;
import de.extrastandard.persistence.model.ExecutionPersistenceJpa;
import de.extrastandard.persistence.model.ProcessTransition;
import de.extrastandard.persistence.repository.ExecutionRepository;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"/spring-persistence-jpa.xml", "/conf/acceptance/phase2/property-placeholder-acceptance-phase2.xml", "/conf/acceptance/spring-acceptance-flyway.xml"})
@TransactionConfiguration(transactionManager="transactionManager", defaultRollback=true)
@Transactional
public class Phase2AcceptanceIT {
    private static final Logger logger = LoggerFactory.getLogger(Phase2AcceptanceIT.class);
    private static final String TEST_CONFIG = "/conf/phase2";
    private static final String LOG_DIR = "/logs";
    private final ExtraClientTestBasic extraClientTestBasic = new ExtraClientTestBasic();
    @Inject
    @Named(value="executionPersistenceJpa")
    private ExecutionPersistenceJpa executionPersistenceJpa;
    @Inject
    @Named(value="executionRepository")
    private ExecutionRepository executionRepository;

    @Before
    public void setUp() throws Exception {
        ExtraClient extraClient = this.extraClientTestBasic.createExtraKlient(TEST_CONFIG, LOG_DIR);
        this.extraClientTestBasic.testExecute(extraClient);
    }

    @Test
    public void checkDBResuls() {
        logger.info("CheckDBResults started");
        boolean expectedExecutionSize = true;
        int expectedCommunicationProtocolsSize = 3;
        String expectedPhase = "PHASE2";
        String expectedNextPhase = "PHASE3";
        String expectedParametersSuffix = "phase2";
        String expectedReturnCode = "C00";
        List allExecutions = this.executionRepository.findAll();
        Assert.assertEquals((String)"Unexpected Execution Size", (long)1L, (long)allExecutions.size());
        for (Execution execution : allExecutions) {
            Assert.assertNull((String)"ErrorCode is not null", (Object)execution.getErrorCode());
            Assert.assertNull((String)"ErrorMessage is not null", (Object)execution.getErrorMessage());
            Assert.assertEquals((String)"Unexpected Phase", (Object)"PHASE2", (Object)execution.getPhase());
            Assert.assertNotNull((String)"Parameters ist null", (Object)execution.getParameters());
            Assert.assertTrue((String)"Unexpected Parameters", (boolean)execution.getParameters().endsWith("phase2"));
            ProcessTransition lastTransition = execution.getLastTransition();
            Assert.assertNotNull((String)"LastTransition ist null", (Object)lastTransition);
            String statusName = lastTransition.getCurrentStatus().getName();
            Assert.assertEquals((String)"Unexpected Phase", (Object)PersistentStatus.DONE.name(), (Object)statusName);
            Set communicationProtocols = execution.getCommunicationProtocols();
            Assert.assertEquals((String)"Unexpected Count of CommunicationProtokols", (long)3L, (long)communicationProtocols.size());
            for (ICommunicationProtocol communicationProtocol : communicationProtocols) {
                Assert.assertEquals((String)"Unexpected ReturnCode", (Object)"C00", (Object)communicationProtocol.getReturnCode());
                IPhaseConnection nextPhaseConnection = communicationProtocol.getNextPhaseConnection();
                Assert.assertNotNull((String)"NextPhaseConnection is null", (Object)nextPhaseConnection);
                String nextPhaseQualifier = nextPhaseConnection.getNextPhasequalifier();
                Assert.assertEquals((String)"Unexpected NextPhase", (Object)"PHASE3", (Object)nextPhaseQualifier);
                String nextPhaseStatusName = nextPhaseConnection.getStatus().getName();
                Assert.assertEquals((String)"Unexpected NextPhase Status", (Object)PersistentStatus.INITIAL.name(), (Object)nextPhaseStatusName);
            }
        }
        logger.info("CheckDBResults successfully completed");
    }
}

