/*
 * Decompiled with CFR 0.152.
 */
package de.extra.client.starter;

import de.extra.client.core.ClientCore;
import de.extra.client.core.ClientProcessResult;
import de.extra.client.starter.ApplicationContextStarter;
import de.extrastandard.api.exception.ExceptionCode;
import de.extrastandard.api.exception.ExtraConfigRuntimeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ExtraClient {
    private static final Logger logger = LoggerFactory.getLogger(ExtraClient.class);
    private static final Logger opperation_logger = LoggerFactory.getLogger((String)"de.extra.client.operation");
    private static final String PROPERTIES_BASIC_FILENAME = "extra-properties-basic.properties";
    private static final String PROPERTIES_USER_FILENAME = "extra-properties-user.properties";
    private static final String SPRING_XML_FILE_PATH = "spring-cli.xml";
    private final File configurationDirectory;

    public ExtraClient(File configurationDirectory) {
        this.configurationDirectory = configurationDirectory;
    }

    public ClientProcessResult execute() {
        opperation_logger.info("Start Of Processing.");
        logger.debug("Load ApplicationContext");
        try {
            ApplicationContext applicationContext = this.createApplicationContext();
            ClientCore clientCore = (ClientCore)applicationContext.getBean("clientCore", ClientCore.class);
            ClientProcessResult processResult = clientCore.process(this.configurationDirectory.getAbsolutePath());
            opperation_logger.info("ExecutionsResults: {}", (Object)processResult.printResults());
            return processResult;
        }
        catch (Exception e) {
            logger.error("Fehler beim Start", (Throwable)e);
            throw new ExtraConfigRuntimeException((Throwable)e);
        }
    }

    ApplicationContext createApplicationContext() throws Exception {
        ApplicationContext applicationContext = null;
        File basicPropsFile = new File(this.configurationDirectory, PROPERTIES_BASIC_FILENAME);
        if (!basicPropsFile.exists() || !basicPropsFile.canRead()) {
            throw new ExtraConfigRuntimeException(ExceptionCode.EXTRA_CONFIGURATION_EXCEPTION, String.format("Konfiguration nicht gefunden: %s", PROPERTIES_BASIC_FILENAME));
        }
        File userPropsFile = new File(this.configurationDirectory, PROPERTIES_USER_FILENAME);
        if (!userPropsFile.exists() || !userPropsFile.canRead()) {
            throw new ExtraConfigRuntimeException(ExceptionCode.EXTRA_CONFIGURATION_EXCEPTION, String.format("Konfiguration nicht gefunden: %s", PROPERTIES_USER_FILENAME));
        }
        Properties basicProperties = new Properties();
        FileInputStream basicPropsStream = new FileInputStream(basicPropsFile);
        basicProperties.load(basicPropsStream);
        IOUtils.closeQuietly((InputStream)basicPropsStream);
        Properties userProperties = new Properties();
        FileInputStream userPropsStream = new FileInputStream(userPropsFile);
        basicProperties.load(userPropsStream);
        IOUtils.closeQuietly((InputStream)userPropsStream);
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("_extern_extra-properties-basic", basicProperties);
        env.put("_extern_extra-properties-user", userProperties);
        env.put("_configurationDirectory", this.configurationDirectory);
        applicationContext = (ApplicationContext)new ApplicationContextStarter<AbstractApplicationContext>(){

            @Override
            protected AbstractApplicationContext createUninitializedContext() {
                return new ClassPathXmlApplicationContext(new String[]{ExtraClient.SPRING_XML_FILE_PATH}, false);
            }
        }.createApplicationContext(env);
        return applicationContext;
    }
}

