/*
 * Decompiled with CFR 0.152.
 */
package de.extra.client.starter;

import de.extra.client.core.ClientCore;
import de.extra.client.starter.ClientArguments;
import de.extra.client.starter.ExtraClient;
import de.extrastandard.api.exception.ExceptionCode;
import de.extrastandard.api.exception.ExtraConfigRuntimeException;
import de.extrastandard.api.model.execution.PersistentStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

class ExternalCall {
    private static final Logger opperation_logger = LoggerFactory.getLogger((String)"de.extra.client.operation");

    ExternalCall() {
    }

    boolean executeExternalCall(ClientArguments clientArguments, ExtraClient extraClient) {
        opperation_logger.info("Starte Verarbeitung fuer Externen Aufruf.");
        try {
            String aktion;
            PersistentStatus persistentStatusNeu;
            String outputIdentifier;
            ApplicationContext applicationContext = extraClient.createApplicationContext();
            ClientCore clientCore = (ClientCore)applicationContext.getBean("clientCore", ClientCore.class);
            boolean success = false;
            String outputConfirm = clientArguments.getOutputConfirm();
            String outputFailure = clientArguments.getOutputFailure();
            if (outputConfirm != null && outputConfirm.length() > 0) {
                outputIdentifier = outputConfirm;
                persistentStatusNeu = PersistentStatus.DONE;
                aktion = "Externer Aufruf: Datei fehlerfrei verarbeitet, outputIdentifier: " + outputIdentifier;
            } else if (outputFailure != null && outputFailure.length() > 0) {
                outputIdentifier = outputFailure;
                persistentStatusNeu = PersistentStatus.FAIL;
                aktion = "Externer Aufruf: Fehler bei Dateiverarbeitung, outputIdentifier: " + outputIdentifier;
            } else {
                opperation_logger.error("Unbekannter Aufruf!");
                throw new ExtraConfigRuntimeException(ExceptionCode.EXTRA_CONFIGURATION_EXCEPTION);
            }
            opperation_logger.info(aktion);
            success = clientCore.changeCommunicationProtocolStatusByOutputIdentifier(outputIdentifier, persistentStatusNeu);
            opperation_logger.info(success ? "Statusaenderung erfolgreich" : "Fehler bei Statusaenderung (falscher OutputIdentifier?)");
            return success;
        }
        catch (Exception e) {
            opperation_logger.error("Fehler bei Externer Verarbeitung", (Throwable)e);
            throw new ExtraConfigRuntimeException((Throwable)e);
        }
    }
}

