/*
 * Decompiled with CFR 0.152.
 */
package de.extra.client.starter;

import de.extra.client.core.ClientProcessResult;
import de.extra.client.core.ReturnCode;
import de.extra.client.exit.JvmSystemExiter;
import de.extra.client.exit.SystemExiter;
import de.extra.client.logging.LogFileHandler;
import de.extra.client.starter.ClientArguments;
import de.extra.client.starter.ExternalCall;
import de.extra.client.starter.ExtraClient;
import java.io.File;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientStarter {
    private static final Logger LOG = LoggerFactory.getLogger(ClientStarter.class);
    private static final Logger opperation_logger = LoggerFactory.getLogger((String)"de.extra.client.operation");
    private static final SystemExiter EXITER = new JvmSystemExiter();

    public static void main(String[] args) {
        ReturnCode returnCode = ReturnCode.SUCCESS;
        ClientArguments clientArguments = new ClientArguments(args, EXITER);
        try {
            clientArguments.parseArgs();
        }
        catch (Exception e) {
            clientArguments.printHelpText(e);
            EXITER.exit(ReturnCode.TECHNICAL);
        }
        if (clientArguments.isShowHelp()) {
            clientArguments.printHelpText(null);
            EXITER.exit(returnCode);
        }
        opperation_logger.info("Eingabeparameter: " + Arrays.toString(args));
        File configurationDirectory = clientArguments.getConfigDirectory();
        new LogFileHandler(clientArguments.getLogDirectory(), configurationDirectory);
        ExtraClient extraClient = new ExtraClient(configurationDirectory);
        if (clientArguments.isExternalCall()) {
            try {
                ExternalCall externalCall = new ExternalCall();
                boolean success = externalCall.executeExternalCall(clientArguments, extraClient);
                returnCode = success ? ReturnCode.SUCCESS : ReturnCode.TECHNICAL;
            }
            catch (Exception e) {
                LOG.error("Fehler bei der Verarbeitung", (Throwable)e);
                returnCode = ReturnCode.TECHNICAL;
            }
        } else {
            try {
                ClientProcessResult result = extraClient.execute();
                returnCode = result.getReturnCode();
            }
            catch (Exception e) {
                LOG.error("Fehler bei der Verarbeitung", (Throwable)e);
                returnCode = ReturnCode.BUSINESS;
            }
        }
        if (returnCode.getCode() != 0) {
            LOG.error("Fehler bei der Verarbeitung: " + returnCode);
        } else {
            LOG.info("Verarbeitung erfolgreich");
        }
        EXITER.exit(returnCode);
    }
}

