/*
 * Decompiled with CFR 0.152.
 */
package de.extra.client.starter;

import de.extra.client.core.ReturnCode;
import de.extra.client.exit.SystemExiter;
import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.springframework.util.StringUtils;

public class ClientArguments {
    public static final String OPTION_NAME_HELP = "help";
    public static final String OPTION_NAME_HELP_SHORTCUT = "h";
    public static final String OPTION_NAME_CONFIGDIR = "configDirectory";
    public static final String OPTION_NAME_CONFIGDIR_SHORTCUT = "c";
    public static final String OPTION_NAME_LOGDIR = "logDirectory";
    public static final String OPTION_NAME_LOGDIR_SHORTCUT = "l";
    public static final String OPTION_NAME_OUTPUT_CONFIRM = "outputConfirm";
    public static final String OPTION_NAME_OUTPUT_CONFIRM_SHORTCUT = "oc";
    public static final String OPTION_NAME_OUTPUT_FAILURE = "outputFailure";
    public static final String OPTION_NAME_OUTPUT_FAILURE_SHORTCUT = "of";
    private static final Option OPT_HELP = new Option("h", "help", false, "Hilfe anzeigen");
    private static final Option OPT_CONFIGDIRECTORY = new Option("c", "configDirectory", true, "Konfigurationsverzeichnis");
    private static final Option OPT_LOGDIRECTORY = new Option("l", "logDirectory", true, "Logverzeichnis");
    private static final Option OPT_OUTPUT_CONFIRM = new Option("oc", "outputConfirm", true, "Korrekten Output best\u00e4tigen");
    private static final Option OPT_OUTPUT_FAILURE = new Option("of", "outputFailure", true, "Fehlerhaften Output melden");
    public static final Options OPTIONS = new Options();
    private final SystemExiter exiter;
    private final String[] args;
    private File configDirectory = null;
    private File logDirectory = null;
    private String outputConfirm = null;
    private String outputFailure = null;
    private Boolean showHelp = null;

    public ClientArguments(String[] args, SystemExiter exiter) {
        this.args = args;
        this.exiter = exiter;
    }

    public void parseArgs() {
        String optionValue;
        PosixParser parser = new PosixParser();
        CommandLine commandLine = null;
        try {
            commandLine = parser.parse(OPTIONS, this.args);
        }
        catch (ParseException e) {
            this.printHelpText((Exception)((Object)e));
            this.exiter.exit(ReturnCode.TECHNICAL);
        }
        this.showHelp = commandLine.hasOption(OPTION_NAME_HELP);
        if (commandLine.hasOption(OPTION_NAME_LOGDIR)) {
            String string = optionValue = commandLine.getOptionValue(OPTION_NAME_LOGDIR) != null ? commandLine.getOptionValue(OPTION_NAME_LOGDIR).trim() : null;
            if (!StringUtils.hasText((String)optionValue)) {
                throw new IllegalArgumentException("Logverzeichnis muss angegeben werden.");
            }
            this.logDirectory = new File(optionValue);
            this.checkDirectory(optionValue, this.logDirectory);
        } else if (Boolean.FALSE.equals(this.showHelp)) {
            throw new IllegalArgumentException("Bitte Parameter angeben.");
        }
        if (commandLine.hasOption(OPTION_NAME_CONFIGDIR)) {
            String string = optionValue = commandLine.getOptionValue(OPTION_NAME_CONFIGDIR) != null ? commandLine.getOptionValue(OPTION_NAME_CONFIGDIR).trim() : null;
            if (!StringUtils.hasText((String)optionValue)) {
                throw new IllegalArgumentException("Konfigurationsverzeichnis muss angegeben werden.");
            }
            this.configDirectory = new File(optionValue);
            this.checkDirectory(optionValue, this.configDirectory);
        } else if (Boolean.FALSE.equals(this.showHelp)) {
            throw new IllegalArgumentException("Bitte Parameter angeben.");
        }
        if (commandLine.hasOption(OPTION_NAME_OUTPUT_CONFIRM)) {
            String string = optionValue = commandLine.getOptionValue(OPTION_NAME_OUTPUT_CONFIRM) != null ? commandLine.getOptionValue(OPTION_NAME_OUTPUT_CONFIRM).trim() : null;
            if (!StringUtils.hasText((String)optionValue)) {
                throw new IllegalArgumentException("Dateiname (OutputIdentifier) muss angegeben werden.");
            }
            this.outputConfirm = optionValue;
        }
        if (commandLine.hasOption(OPTION_NAME_OUTPUT_FAILURE)) {
            String string = optionValue = commandLine.getOptionValue(OPTION_NAME_OUTPUT_FAILURE) != null ? commandLine.getOptionValue(OPTION_NAME_OUTPUT_FAILURE).trim() : null;
            if (!StringUtils.hasText((String)optionValue)) {
                throw new IllegalArgumentException("Dateiname (OutputIdentifier) muss angegeben werden.");
            }
            this.outputFailure = optionValue;
        }
        if (this.showHelp == null && this.configDirectory == null) {
            throw new IllegalArgumentException("Bitte Parameter angeben.");
        }
    }

    private void checkDirectory(String optionValue, File directory) {
        if (!directory.exists()) {
            throw new IllegalArgumentException(String.format("Verzeichnis existiert nicht: %s", directory));
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(String.format("Verzeichnis ist kein Verzeichnis: %s", directory));
        }
        if (!directory.canRead()) {
            throw new IllegalArgumentException(String.format("Verzeichnis nicht zugreifbar: %s", directory));
        }
    }

    public void printHelpText(Exception e) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("extraClient", OPTIONS);
        if (e != null) {
            System.out.println("\nFehler: " + e.getMessage());
        }
    }

    public boolean isShowHelp() {
        return this.showHelp;
    }

    public boolean isExternalCall() {
        return this.outputConfirm != null || this.outputFailure != null;
    }

    public File getConfigDirectory() {
        return this.configDirectory;
    }

    public File getLogDirectory() {
        return this.logDirectory;
    }

    public String getOutputConfirm() {
        return this.outputConfirm;
    }

    public String getOutputFailure() {
        return this.outputFailure;
    }

    static {
        OPTIONS.addOption(OPT_HELP);
        OPTIONS.addOption(OPT_CONFIGDIRECTORY);
        OPTIONS.addOption(OPT_LOGDIRECTORY);
        OPTIONS.addOption(OPT_OUTPUT_CONFIRM);
        OPTIONS.addOption(OPT_OUTPUT_FAILURE);
    }
}

