/*
 * Decompiled with CFR 0.152.
 */
package de.extra.client.starter;

import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;

public abstract class ApplicationContextStarter<C extends ConfigurableApplicationContext> {
    protected abstract C createUninitializedContext();

    public C createApplicationContext(final Map<String, Object> preregisteredObjects) {
        C context = this.createUninitializedContext();
        BeanFactoryPostProcessor beanFactoryPostProcessor = new BeanFactoryPostProcessor(){

            public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
                for (Map.Entry entry : preregisteredObjects.entrySet()) {
                    beanFactory.registerSingleton((String)entry.getKey(), entry.getValue());
                }
            }
        };
        context.addBeanFactoryPostProcessor(beanFactoryPostProcessor);
        context.refresh();
        return context;
    }
}

