/*
 * Decompiled with CFR 0.152.
 */
package de.extra.client.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import de.extra.client.core.ReturnCode;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class LogFileHandler {
    private static final String LOGBACK_CONFIG = "logging-config.xml";
    private static final Logger LOG = LoggerFactory.getLogger(LogFileHandler.class);
    private final File logDirectory;
    private final File configurationDirectory;

    public LogFileHandler(File logDirectory, File configurationDirectory) {
        Assert.notNull((Object)logDirectory, (String)"logDirectory darf nicht leer sein.");
        Assert.notNull((Object)configurationDirectory, (String)"configurationDirectory darf nicht leer sein.");
        this.logDirectory = logDirectory;
        this.configurationDirectory = configurationDirectory;
        this.initializeLogFile();
    }

    private void initializeLogFile() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)context);
        context.reset();
        context.putProperty("logfilepath", this.logDirectory.getAbsolutePath());
        try {
            configurator.doConfigure(new File(this.configurationDirectory, LOGBACK_CONFIG));
        }
        catch (JoranException e) {
            this.exitWithError(e.getMessage(), e);
        }
        LOG.debug("successfully configured log system, file={}", (Object)this.logDirectory.getAbsolutePath());
    }

    private void exitWithError(String message, Throwable exception) {
        LOG.error("Fehler bei der Konfiguration des Loggingsystems: {}", (Object)message, (Object)exception);
        System.exit(ReturnCode.TECHNICAL.getCode());
    }
}

