/*
 * Decompiled with CFR 0.152.
 */
package de.extra.client.starter;

import de.extra.client.core.ReturnCode;
import de.extra.client.exit.SystemExiter;
import de.extra.client.starter.ClientArguments;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.core.io.ClassPathResource;

public class ClientArgumentsTest {
    @Test
    public void testClientArguments() throws Exception {
        ClassPathResource configDir = new ClassPathResource("testconfig");
        ClassPathResource logDir = new ClassPathResource("log");
        String[] args = new String[]{"-c " + configDir.getFile().getAbsolutePath(), "-l  " + logDir.getFile().getAbsolutePath()};
        ClientArguments arguments = new ClientArguments(args, (SystemExiter)new NotExiter());
        arguments.parseArgs();
        Assert.assertNotNull((Object)arguments.getConfigDirectory());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseNonArgs() {
        ClientArguments arguments = new ClientArguments(null, (SystemExiter)new NotExiter());
        arguments.parseArgs();
    }

    public void testHelp() throws Exception {
        ClientArguments arguments = new ClientArguments(new String[]{"-h"}, (SystemExiter)new NotExiter());
        arguments.parseArgs();
        Assert.assertTrue((boolean)arguments.isShowHelp());
    }

    static class NotExiter
    implements SystemExiter {
        NotExiter() {
        }

        public void exit(ReturnCode code) {
        }
    }
}

