package de.envisia.api.libs

import javax.inject.Singleton

import play.api.inject.Module
import play.api.libs.ws.{WSAPI, WSClient}
import play.api.{Configuration, Environment}

class EnvisiaWSModule extends Module {
  def bindings(environment: Environment, configuration: Configuration) = {
    Seq(
      bind[WSAPI].to[EnvisiaWS],
      bind[WSClient].toProvider[EnvisiaWSProvider].in[Singleton]
    )
  }
}
