package de.envisia.api.libs

import java.security.cert.X509Certificate
import javax.inject.{Inject, Singleton}
import javax.net.ssl.{SSLContext, TrustManager, X509TrustManager}

import play.api.Logger
import play.api.inject.ApplicationLifecycle
import play.api.libs.ws.ning.NingWSClient
import play.api.libs.ws.{WSAPI, WSClient, WSRequest}

import scala.concurrent.Future


@Singleton
class EnvisiaWS @Inject()(lifecycle: ApplicationLifecycle) extends WSAPI {

  val logger = Logger(this.getClass)
  logger.debug(s"Client Initialization")

  private val tm = new X509TrustManager {
    override def getAcceptedIssuers: Array[X509Certificate] = null

    override def checkClientTrusted(x509Certificates: Array[X509Certificate], s: String): Unit = {}

    override def checkServerTrusted(x509Certificates: Array[X509Certificate], s: String): Unit = {}
  }

  private val builder = new com.ning.http.client.AsyncHttpClientConfig.Builder()
  builder.setAcceptAnyCertificate(true)

  private val context = SSLContext.getInstance("TLS")
  context.init(null, Array[TrustManager](tm), null)
  builder.setSSLContext(context)

  private val config = builder.build()

  override def url(url: String): WSRequest = client.url(url)

  override lazy val client: WSClient = {
    val client = new NingWSClient(config)

    lifecycle.addStopHook { () =>
      Future.successful(client.close())
    }

    client
  }

}