define(["t5/core/dom", "jquery", "t5/core/ajax", "t5/core/console", "underscore"], function(dom, $, ajax, console, _) {
  var addMoreContent, bodyscrolled, init;
  bodyscrolled = function(bodyWrapper, url) {
    var spaceToBottom, tableBody;
    tableBody = bodyWrapper.find('tbody');
    if (tableBody.data('all-rows-shown')) {
      return;
    }
    spaceToBottom = tableBody.height() - bodyWrapper.scrollTop() - bodyWrapper.height();
    if (spaceToBottom < 150) {
      addMoreContent(tableBody, url);
    }
  };
  addMoreContent = function(tableBody, url) {
    return ajax(url, {
      data: {
        from: (tableBody.find('tr')).length
      },
      success: function(response) {
        var col, i, j, k, len, len1, newRow, ref, row, td;
        ref = response.json.rows;
        for (j = 0, len = ref.length; j < len; j++) {
          row = ref[j];
          console.debug("Received row : " + row);
          newRow = (tableBody.find('tr')).eq(0).clone();
          newRow.attr('data-grid-row', null);
          for (i = k = 0, len1 = row.length; k < len1; i = ++k) {
            col = row[i];
            td = (newRow.find('td')).eq(i);
            td.html(col);
          }
          tableBody.append(newRow);
        }
        if (!response.json.more) {
          tableBody.data('all-rows-shown', true);
        }
      }
    });
  };
  init = function(id, url) {
    var bodyWrapper, headHeight, headWrapper, i, j, k, l, len, len1, len2, ref, ref1, ref2, row, table, tableCopy, tableHeight, tbl, tbody, th, thWidths;
    table = $('#' + id);
    tbody = table.find('tbody');
    tableHeight = table.outerHeight(true);
    headHeight = (table.find('thead')).height();
    headWrapper = $('<div class="infinigridHead"/>');
    table.wrap('<div/>');
    bodyWrapper = table.parent();
    tableCopy = table.clone();
    tableCopy.removeAttr('id');
    bodyWrapper.before(headWrapper);
    headWrapper.append(tableCopy);
    thWidths = (function() {
      var j, len, ref, results;
      ref = ($(tableCopy)).find('th');
      results = [];
      for (j = 0, len = ref.length; j < len; j++) {
        th = ref[j];
        results.push(($(th)).outerWidth());
      }
      return results;
    })();
    ref = ($(tableCopy)).find('th');
    for (i = j = 0, len = ref.length; j < len; i = ++j) {
      th = ref[i];
      ref1 = (table.find('tr')).eq(0);
      for (k = 0, len1 = ref1.length; k < len1; k++) {
        row = ref1[k];
        ((($(row)).find('td,th')).eq(i)).width(thWidths[i]);
      }
      ($(th)).width(thWidths[i]);
    }
    (tableCopy.find('tbody')).remove();
    ref2 = [tableCopy, table];
    for (l = 0, len2 = ref2.length; l < len2; l++) {
      tbl = ref2[l];
      tbl.css('table-layout', 'fixed');
    }
    headWrapper.css({
      height: headHeight
    });
    (table.find('thead th')).html('');
    bodyWrapper.css('paddingBottom', "+=" + (table.css('marginBottom')));
    table.css('marginBottom', 0);
    bodyWrapper.addClass('infinigridBody');
    bodyWrapper.css('height', tableHeight - headHeight);
    bodyWrapper.scroll(_.debounce((function() {
      bodyscrolled(bodyWrapper, url);
    }), 100));
    addMoreContent(bodyWrapper.find('tbody'), url);
  };
  return init;
});
