/*
 * Decompiled with CFR 0.152.
 */
package de.eddyson.tapestry.extensions.mixins;

import java.util.List;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.PropertyConduit;
import org.apache.tapestry5.PropertyOverrides;
import org.apache.tapestry5.annotations.BindParameter;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.InjectContainer;
import org.apache.tapestry5.annotations.RequestParameter;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.beaneditor.PropertyModel;
import org.apache.tapestry5.corelib.components.Any;
import org.apache.tapestry5.corelib.components.Grid;
import org.apache.tapestry5.corelib.data.GridPagerPosition;
import org.apache.tapestry5.grid.GridDataSource;
import org.apache.tapestry5.internal.PropertyOverridesImpl;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.BeanBlockSource;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.PartialTemplateRenderer;
import org.apache.tapestry5.services.PropertyOutputContext;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@Import(stylesheet={"infinigrid.css"})
public class InfiniGrid {
    private static final String EMPTY_STRING = "";
    @InjectContainer
    private Grid grid;
    @BindParameter
    private GridDataSource source;
    @BindParameter
    private int rowsPerPage;
    @BindParameter
    private boolean inPlace;
    @BindParameter
    private GridPagerPosition pagerPosition;
    @Inject
    private ComponentResources resources;
    @Inject
    private JavaScriptSupport javaScriptSupport;
    @Inject
    private BeanBlockSource beanBlockSource;
    @Inject
    private PartialTemplateRenderer partialTemplateRenderer;
    @Inject
    private Environment environment;

    void setupRender() {
        if (!this.inPlace) {
            throw new IllegalArgumentException("The Grid's inPlace parameter must be set to true");
        }
        if (this.pagerPosition != GridPagerPosition.NONE) {
            throw new IllegalArgumentException("The Grid's pagerPosition parameter must be set to NONE");
        }
    }

    void afterRender() {
        if (this.grid.getDataSource().getAvailableRows() > 0) {
            Any table = (Any)this.resources.getContainerResources().getEmbeddedComponent("table");
            String clientId = table.getClientId();
            this.javaScriptSupport.require("de/eddyson/tapestry/extensions/infinigrid").with(new Object[]{clientId, this.resources.createEventLink("action", new Object[0]).toURI()});
        }
    }

    Object onAction(@RequestParameter(value="from") int startIndex) {
        GridDataSource ds = this.source;
        List sortConstraints = this.grid.getSortModel().getSortConstraints();
        int available = ds.getAvailableRows();
        int endIndex = Math.min(available, startIndex + this.rowsPerPage);
        ds.prepare(startIndex, endIndex, sortConstraints);
        JSONArray rows = new JSONArray();
        BeanModel model = this.grid.getDataModel();
        PropertyOverridesImpl overrides = new PropertyOverridesImpl(this.resources.getContainerResources());
        for (int i = startIndex; i < endIndex; ++i) {
            Object o = ds.getRowValue(i);
            JSONArray row = new JSONArray();
            for (final String propertyName : model.getPropertyNames()) {
                String markup;
                String dataType;
                boolean isOverrideBlock;
                final PropertyModel propertyModel = model.get(propertyName);
                PropertyConduit conduit = propertyModel.getConduit();
                final Object value = conduit != null ? conduit.get(o) : null;
                String propertyBlockOverrideParameterName = propertyName + "Cell";
                Block block = overrides.getOverrideBlock(propertyBlockOverrideParameterName);
                boolean bl = isOverrideBlock = block != null;
                if (block == null && this.beanBlockSource.hasDisplayBlock(dataType = propertyModel.getDataType())) {
                    block = this.beanBlockSource.getDisplayBlock(dataType);
                }
                if (block != null) {
                    PropertyOutputContext propertyOutputContext = new PropertyOutputContext((PropertyOverrides)overrides){
                        final /* synthetic */ PropertyOverrides val$overrides;
                        {
                            this.val$overrides = propertyOverrides;
                        }

                        public Object getPropertyValue() {
                            return value;
                        }

                        public String getPropertyName() {
                            return propertyName;
                        }

                        public String getPropertyId() {
                            return propertyModel.getId();
                        }

                        public Messages getMessages() {
                            return this.val$overrides.getOverrideMessages();
                        }
                    };
                    this.environment.push(PropertyOutputContext.class, (Object)propertyOutputContext);
                    try {
                        markup = this.partialTemplateRenderer.render((Object)block);
                    }
                    catch (Exception e) {
                        if (isOverrideBlock && InfiniGrid.isCausedByNullPointerException(e)) {
                            throw new IllegalStateException("Cannot render table cell for property " + propertyName + ", try to replace the cell override (parameter " + propertyBlockOverrideParameterName + ") by a BeanBlockSource contribution", e);
                        }
                        throw e;
                    }
                    finally {
                        this.environment.pop(PropertyOutputContext.class);
                    }
                } else {
                    markup = value != null ? value.toString() : EMPTY_STRING;
                }
                row.put((Object)markup);
            }
            rows.put((Object)row);
        }
        JSONObject result = new JSONObject(new Object[]{"rows", rows, "more", available > endIndex});
        return result;
    }

    private static boolean isCausedByNullPointerException(Exception e) {
        Throwable ex = e;
        while (!(ex instanceof NullPointerException) && ex.getCause() != null) {
            ex = ex.getCause();
        }
        return ex instanceof NullPointerException;
    }
}

