/*
 * Decompiled with CFR 0.152.
 */
package de.eddyson.tapestry.extensions.components;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.tapestry5.ComponentEventCallback;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.OnEvent;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.RequestParameter;
import org.apache.tapestry5.corelib.base.AbstractField;
import org.apache.tapestry5.internal.util.CaptureResultCallback;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.Request;
import org.slf4j.Logger;

@Import(stylesheet={"webjars:select2:$version/dist/css/select2.css"})
public class Tagging
extends AbstractField {
    @Parameter
    List<String> initialTags;
    @Property
    @Parameter(autoconnect=true)
    List<String> tags;
    @Parameter(value="literal:None...")
    String placeholder;
    @Inject
    Logger logger;
    @Inject
    Request request;
    @Inject
    TypeCoercer typeCoercer;

    protected void processSubmission(String controlName) {
        String[] submittedTags = this.request.getParameters(controlName + "[]");
        this.tags = submittedTags != null ? Arrays.asList(submittedTags) : null;
    }

    @OnEvent(value="internalComplete")
    JSONObject completionValues(@RequestParameter(value="q", allowBlank=true) String searchString) {
        Object[] context = new Object[]{searchString};
        CaptureResultCallback callback = CaptureResultCallback.create();
        Collection completionsRaw = null;
        List<String> completions = null;
        if (searchString == null || searchString.equals("")) {
            completions = this.initialTags;
        } else {
            this.resources.triggerEvent("completeTags", context, (ComponentEventCallback)callback);
            completionsRaw = (List)this.typeCoercer.coerce(callback.getResult(), List.class);
        }
        if (completionsRaw != null) {
            completions = completionsRaw.stream().map(completion -> (String)this.typeCoercer.coerce(completion, String.class)).collect(Collectors.toList());
        }
        this.logger.debug("Coerced tag completions for Tagging component ({}): {}", (Object)this.resources.getId(), completions);
        JSONArray completionsArray = new JSONArray();
        if (completions != null) {
            completions.stream().forEach(completion -> completionsArray.put((Object)new JSONObject(new Object[]{"id", completion, "text", completion})));
        }
        return new JSONObject(new Object[]{"data", completionsArray});
    }

    void beginRender(MarkupWriter writer) {
        writer.element("select", new Object[]{"style", "width: 100%; display: none;", "id", this.getClientId(), "name", this.getControlName() + "[]", "multiple", "multiple"});
        if (this.tags != null) {
            this.tags.stream().forEach(initialTag -> {
                writer.element("option", new Object[]{"value", initialTag}).text(initialTag);
                writer.attributes(new Object[]{"selected", "selected"});
                writer.end();
            });
        }
        writer.end();
    }

    void afterRender() {
        this.javaScriptSupport.require("de/eddyson/tapestry/extensions/tagging").with(new Object[]{this.getClientId(), this.resources.createEventLink("internalComplete", new Object[0]).toURI(), this.placeholder});
    }
}

