/*
 * Decompiled with CFR 0.152.
 */
package de.eddyson.tapestry.extensions.components;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tapestry5.Binding;
import org.apache.tapestry5.ComponentEventCallback;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.FieldValidationSupport;
import org.apache.tapestry5.FieldValidator;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.OptionModel;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.SelectModelVisitor;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.annotations.BeforeRenderTemplate;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.OnEvent;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.RequestParameter;
import org.apache.tapestry5.annotations.SetupRender;
import org.apache.tapestry5.corelib.base.AbstractField;
import org.apache.tapestry5.corelib.data.BlankOption;
import org.apache.tapestry5.internal.util.CaptureResultCallback;
import org.apache.tapestry5.internal.util.SelectModelRenderer;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.internal.util.GenericsUtils;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.ValueEncoderSource;
import org.slf4j.Logger;

@Import(stylesheet={"webjars:select2:$version/dist/css/select2.css"})
public class MultiSelect
extends AbstractField {
    public static final String EVENT_CHANGED = "changed";
    public static final String SELECTION_CHANGED = "selection_changed";
    public static final String BLANK_OPTION_VALUE = "-1";
    @Property
    @Parameter(required=true)
    Collection<Object> selected;
    @Property
    @Parameter(required=true, allowNull=false)
    ValueEncoder<Object> encoder;
    @Inject
    Request request;
    @Inject
    Logger logger;
    @Parameter(value="true")
    boolean multiple;
    @Parameter(defaultPrefix="literal")
    private String theme;
    @Property
    @Parameter(autoconnect=true)
    SelectModel model;
    @Inject
    private FieldValidationSupport fieldValidationSupport;
    @Inject
    private ValueEncoderSource valueEncoderSource;
    @Parameter(defaultPrefix="validate")
    private FieldValidator<Object> validate;
    @Parameter(value="auto", defaultPrefix="literal")
    private BlankOption blankOption;
    @Parameter(defaultPrefix="literal")
    private String blankLabel;
    @Parameter(value="false")
    private boolean raw;
    @Parameter(value="true")
    private boolean async;
    @Property
    Object currentOption;

    public String toClient() {
        return this.encoder.toClient(this.currentOption);
    }

    public boolean isSelected(String clientValue) {
        return this.selected.contains(this.encoder.toValue(clientValue));
    }

    @SetupRender
    void initialize() {
        if (this.selected == null) {
            this.selected = new ArrayList<Object>();
        }
    }

    protected void processSubmission(String controlName) {
        String singleValue;
        String[] submittedValues = this.request.getParameters(controlName + "[]");
        this.logger.debug("Submitted value from MultiSelect with id -> {} are: {}", (Object)this.resources.getCompleteId(), (Object)submittedValues);
        if (submittedValues != null) {
            this.selected = Arrays.stream(submittedValues).filter(s -> !s.equals(BLANK_OPTION_VALUE)).map(arg_0 -> this.encoder.toValue(arg_0)).collect(Collectors.toList());
        } else if (this.request.getParameters(controlName) != null && (singleValue = this.request.getParameter(controlName)) != BLANK_OPTION_VALUE) {
            String quotesRemoved = singleValue.substring(1, singleValue.length() - 1);
            this.selected.add(this.encoder.toValue(quotesRemoved));
        }
        this.putPropertyNameIntoBeanValidationContext("selected");
        try {
            this.fieldValidationSupport.validate(this.selected, this.resources, this.validate);
        }
        catch (ValidationException e) {
            this.validationTracker.recordError((Field)this, e.getMessage());
        }
        this.removePropertyNameFromBeanValidationContext();
    }

    void renderBody(MarkupWriter writer) {
        writer.element("select", new Object[0]);
        writer.end();
    }

    void afterRender() {
        this.javaScriptSupport.require("de/eddyson/tapestry/extensions/multi-select").with(new Object[]{this.getClientId(), this.multiple, this.isRequired(), this.blankLabel != null ? this.blankLabel : JSONObject.NULL, Optional.ofNullable(this.theme).orElse((String)JSONObject.NULL)});
    }

    public String getId() {
        return this.getClientId();
    }

    @OnEvent(value="changed")
    public Object changed(List<String> context, @RequestParameter(value="values", allowBlank=true) String string) {
        this.logger.debug("Event <{}> from component <{}> with values: {}", new Object[]{EVENT_CHANGED, this.resources.getCompleteId(), string});
        CaptureResultCallback callback = new CaptureResultCallback();
        if (string.startsWith("\"")) {
            Object[] singleContextValue = new Object[1];
            String quotesRemoved = string.substring(1, string.length() - 1);
            ArrayList<Object> currentSelectedValue = new ArrayList<Object>();
            this.logger.debug("Single value submitted from component <{}> : {}", (Object)this.resources.getCompleteId(), singleContextValue[0]);
            try {
                singleContextValue[0] = this.encoder.toValue(quotesRemoved);
            }
            catch (Exception e) {
                if (!quotesRemoved.equals(BLANK_OPTION_VALUE)) {
                    this.logger.error("Error encoding value {} sent from {} with encoder {}.", new Object[]{quotesRemoved, this.resources.getCompleteId(), this.encoder.getClass().getName()});
                }
                singleContextValue[0] = quotesRemoved;
            }
            if (!singleContextValue[0].equals(BLANK_OPTION_VALUE)) {
                currentSelectedValue.add(singleContextValue[0]);
                this.resources.triggerEvent(SELECTION_CHANGED, singleContextValue, (ComponentEventCallback)callback);
            } else {
                this.logger.debug("Single value submitted from component <{}> : {} is blank option. Clearing context.", (Object)this.resources.getCompleteId(), singleContextValue[0]);
                this.resources.triggerEvent(SELECTION_CHANGED, null, (ComponentEventCallback)callback);
            }
            this.selected = currentSelectedValue;
        } else if (string.startsWith("[")) {
            try {
                JSONArray values = new JSONArray(string);
                List sentValues = values.toList().stream().filter(s -> !s.equals(BLANK_OPTION_VALUE)).map(obj -> this.encoder.toValue((String)obj)).collect(Collectors.toList());
                Object[] newContext = Stream.concat(sentValues.stream(), context.stream()).toArray();
                this.logger.debug("Values submitted from component <{}> -> Encoded:  {}", (Object)this.resources.getCompleteId(), (Object)newContext);
                this.resources.triggerEvent(SELECTION_CHANGED, newContext, (ComponentEventCallback)callback);
                this.selected = sentValues;
            }
            catch (RuntimeException e) {
                this.logger.error("Could not decode multiple values from <{}> event. From component: {}. Submitted values: {}. Exception: {}", new Object[]{EVENT_CHANGED, this.resources.getCompleteId(), string, e.getMessage()});
                this.resources.triggerEvent(SELECTION_CHANGED, null, (ComponentEventCallback)callback);
                this.selected = null;
            }
        } else {
            this.resources.triggerEvent(SELECTION_CHANGED, null, (ComponentEventCallback)callback);
            this.logger.debug("Could not decode value from <{}> event. From component: {}. Submitted values: {}", new Object[]{EVENT_CHANGED, this.resources.getCompleteId(), string});
            this.selected = null;
        }
        return callback.getResult();
    }

    public String getChangeEventUrl() {
        return this.resources.createEventLink(EVENT_CHANGED, new Object[0]).toURI();
    }

    void beginRender(MarkupWriter writer) {
        writer.element("select", new Object[]{"name", this.getControlName() + "[]", "id", this.getClientId(), "class", this.cssClass, "style", "display:none;"});
        if (this.multiple) {
            writer.attributes(new Object[]{"multiple", "multiple"});
        }
        if (this.async) {
            writer.attributes(new Object[]{"data-change-uri", this.getChangeEventUrl()});
        }
        this.putPropertyNameIntoBeanValidationContext("selected");
        this.validate.render(writer);
        this.removePropertyNameFromBeanValidationContext();
        this.resources.renderInformalParameters(writer);
        this.decorateInsideField();
    }

    @BeforeRenderTemplate
    void options(MarkupWriter writer) {
        if (this.showBlankOption()) {
            writer.element("option", new Object[]{"value", BLANK_OPTION_VALUE});
            writer.write(this.blankLabel);
            writer.end();
        }
        Renderer renderer = new Renderer(writer);
        this.model.visit((SelectModelVisitor)renderer);
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
    }

    private boolean showBlankOption() {
        switch (this.blankOption) {
            case ALWAYS: {
                return true;
            }
            case NEVER: {
                return false;
            }
        }
        return !this.isRequired();
    }

    Object defaultBlankLabel() {
        String key;
        Messages containerMessages = this.resources.getContainerMessages();
        if (containerMessages.contains(key = this.resources.getId() + "-blanklabel")) {
            return containerMessages.get(key);
        }
        return null;
    }

    Binding defaultValidate() {
        return this.defaultProvider.defaultValidatorBinding("selected", this.resources);
    }

    ValueEncoder<?> defaultEncoder() {
        Type parameterType = this.resources.getBoundGenericType("selected");
        if (parameterType == null || !(parameterType instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)parameterType;
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        if (typeArguments.length != 1) {
            return null;
        }
        return this.valueEncoderSource.getValueEncoder(GenericsUtils.asClass((Type)typeArguments[0]));
    }

    private class Renderer
    extends SelectModelRenderer {
        public Renderer(MarkupWriter writer) {
            super(writer, MultiSelect.this.encoder, MultiSelect.this.raw);
        }

        protected boolean isOptionSelected(OptionModel optionModel, String clientValue) {
            return MultiSelect.this.isSelected(clientValue);
        }
    }
}

