/*
 * Decompiled with CFR 0.152.
 */
package de.eddyson.tapestry.extensions;

import java.lang.annotation.Annotation;
import java.util.function.Function;
import org.apache.tapestry5.PropertyConduit;

public interface DefaultReadOnlyPropertyConduit
extends PropertyConduit {
    public static <T> PropertyConduit createStringConduit(Function<Object, String> accessor) {
        return DefaultReadOnlyPropertyConduit.create(String.class, accessor);
    }

    public static <T> PropertyConduit create(Class<T> returnType, Function<Object, ? extends T> accessor) {
        return new DefaultReadOnlyPropertyConduitImpl(returnType, accessor);
    }

    default public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return null;
    }

    default public void set(Object instance, Object value) {
        throw new UnsupportedOperationException("Cannot set this property");
    }

    public static class DefaultReadOnlyPropertyConduitImpl<T>
    implements DefaultReadOnlyPropertyConduit {
        private final Class<T> returnType;
        private final Function<Object, ? extends T> accessor;

        private DefaultReadOnlyPropertyConduitImpl(Class<T> returnType, Function<Object, ? extends T> accessor) {
            this.returnType = returnType;
            this.accessor = accessor;
        }

        public Class<T> getPropertyType() {
            return this.returnType;
        }

        public Object get(Object instance) {
            return this.accessor.apply(instance);
        }
    }
}

