/*
 * Decompiled with CFR 0.152.
 */
package org.d_haven.eventbus;

import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import org.d_haven.eventbus.BusListener;
import org.d_haven.eventbus.EventBus;
import org.d_haven.eventbus.Filter;
import org.d_haven.eventbus.Subscriber;

public final class DefaultEventBus
implements EventBus {
    protected final Collection m_subscriptions = new LinkedList();
    protected BusListener m_busListener;
    static /* synthetic */ Class class$java$util$EventObject;

    public void setErrorListener(BusListener listener) {
        this.m_busListener = listener;
    }

    public void publish(EventObject event) {
        this.fireEventPublished(event);
        EventDispatcher dispatcher = new EventDispatcher(event);
        SwingUtilities.invokeLater(dispatcher);
    }

    private void fireEventPublished(EventObject event) {
        if (null != this.m_busListener) {
            this.m_busListener.eventPublished(event);
        }
    }

    private void fireEventError(EventObject event, Exception e) {
        if (this.m_busListener != null) {
            this.m_busListener.eventError(event, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(Class eventType, Filter filter, Subscriber subscriber) {
        this.checkSubscriberInfo(eventType, subscriber);
        Subscription subscription = new Subscription(eventType, filter, subscriber);
        Collection collection = this.m_subscriptions;
        synchronized (collection) {
            this.m_subscriptions.add(subscription);
        }
    }

    private void checkSubscriberInfo(Class eventType, Subscriber subscriber) {
        if (!(class$java$util$EventObject == null ? (class$java$util$EventObject = DefaultEventBus.class$("java.util.EventObject")) : class$java$util$EventObject).isAssignableFrom(eventType)) {
            throw new IllegalArgumentException("Invalid event class: " + eventType.getName());
        }
        if (null == subscriber) {
            throw new IllegalArgumentException("'subscriber' cannot be empty.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(Class eventType, Filter filter, Subscriber subscriber) {
        this.checkSubscriberInfo(eventType, subscriber);
        Subscription subscription = new Subscription(eventType, filter, subscriber);
        Collection collection = this.m_subscriptions;
        synchronized (collection) {
            this.m_subscriptions.remove(subscription);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class Subscription {
        private final Class _eventType;
        private final Filter _filter;
        private final Subscriber _subscriber;

        public Subscription(Class eventType, Filter filter, Subscriber subscriber) {
            this._eventType = eventType;
            this._filter = filter;
            this._subscriber = subscriber;
        }

        public Class getEventType() {
            return this._eventType;
        }

        public Filter getFilter() {
            return this._filter;
        }

        public Subscriber getSubscriber() {
            return this._subscriber;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Subscription)) {
                return false;
            }
            Subscription subscription = (Subscription)o;
            if (!this._eventType.equals(subscription._eventType)) {
                return false;
            }
            if (this._filter != null ? !this._filter.equals(subscription._filter) : subscription._filter != null) {
                return false;
            }
            return this._subscriber.equals(subscription._subscriber);
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this._eventType.hashCode();
            result = 37 * result + (this._filter != null ? this._filter.hashCode() : 0);
            result = 37 * result + this._subscriber.hashCode();
            return result;
        }
    }

    private final class EventDispatcher
    implements Runnable {
        private final EventObject _event;

        public EventDispatcher(EventObject event) {
            this._event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Subscription[] subscriptions;
            Collection collection = DefaultEventBus.this.m_subscriptions;
            synchronized (collection) {
                subscriptions = DefaultEventBus.this.m_subscriptions.toArray(new Subscription[DefaultEventBus.this.m_subscriptions.size()]);
            }
            for (int i = 0; i < subscriptions.length; ++i) {
                Subscription subscription = subscriptions[i];
                if (!subscription.getEventType().isAssignableFrom(this._event.getClass()) || subscription.getFilter() != null && !subscription.getFilter().apply(this._event)) continue;
                try {
                    subscription.getSubscriber().inform(this._event);
                    continue;
                }
                catch (Exception e) {
                    DefaultEventBus.this.fireEventError(this._event, e);
                }
            }
        }
    }
}

