(ns wms-customer-info.core)

;;var wms_customer_info={
;   firstName:'Dikie',
;   lastName:'Ballard',
;   regId:'9F424FDF-FAB8-4E29-80DF-0B634B3AF009',
;   clubcode:'212',
;   ubiEnabled:'true',
;   apiServiceUrl: 'https://mypolicy.api.qa.digital.pncie.com/ent/ds/v1/telematics/vehicles/devicestatus?policynumber=',
;   scoreAPI: 'https://mypolicy.api.qa.digital.pncie.com/ent/ds/v1/telematics/vehicles/scoresummary',
;   OAuth: 'eyJhbGciOiJIUzI1NiIsImtpZCI6IjAwMSJ9.eyJ6aXAiOiIiLCJjdXN0b21lcmtleSI6IjlGNDI0RkRGLUZBQjgtNEUyOS04MERGLTBCNjM0QjNBRjAwOSIsImZpcnN0bmFtZSI6IiIsImNsaWVudElEIjoiZTkwYWZkNjktZjcyOS00M2NkLWEyZGEtZDg4MmM2Zjk3MDlhIiwiY2xpZW50TmFtZSI6InNlbGZzZXJ2aWNlLXBvcnRhbCIsImNsdWIiOiIyMTIiLCJ1c2VyaWQiOiJGYWtlIEN1c3RvbWVyIiwiZW1haWwiOiIiLCJsYXN0bmFtZSI6IiIsImV4cCI6MTQ3OTg5Njk5MSwic2NvcGUiOlsic2NvcGUiXSwiY2xpZW50X2lkIjoiY2xpZW50SUQifQ.OA4jrl4CIPUHq8CEQI72eFtJDio-0VYyikjNP-PyzW8',
;   email: 'Chitra.Krishnamurthy@csaa.com',
;   ubiIndicator: 'true'}

(defn wms-saml
  [mdm-id attrs]
  {:mdmid mdm-id
   :firstName (first (.get attrs "givenName"))
   :lastName (first (.get attrs "sn"))
   :OAuth (first (.get attrs "OAuth"))
   :email (first (.get attrs "mail"))
   :regId (first (.get attrs "customerRegistrationID"))
   :clubCode (first (.get attrs "club"))
   })



(defn wms-direct-access
  [mdm-id request]
  {:mdmid mdm-id
   :authorization (get (:headers request) "authorization")
   :OAuth (get (:headers request) "oauth")
   :preferredEmail (get (:headers request) "preferred_email")
   :clubCode (get (:headers request) "club_code")
   :verifyTimeStamp (get (:headers request) "verify_time_stamp")
   :verifyTransactionId (get (:headers request) "verify_transaction_id")
   :directaccess true
   :firstName (get (:headers request) "first_name")
   :lastName (get (:headers request) "last_name")})


