(ns policies.core
  (:require [constants.core :as constants]
            [soa.core :as soa]))

(defn- vehicle-model
  [vehicle]
  {:make (:make vehicle)
   :model (:model vehicle)
   :year (:modelYear vehicle)})

(defn- driver-model
  [driver]
  {:firstName (:firstName (:name driver))
   :lastName (:lastName (:name driver))
   :fullName (:fullName (:name driver))
   :gender (:gender driver)})

(defn address-model
  [address]
  {:street (or (:address1 address) (:streetAddressLine address))
   :city (or (:city address) (:cityName address))
   :state (or (:state address) (:isoRegionCode address))
   :postalCode (:zipCode address)})

(defn- auto-policy-getter
  [policy rapd-response]
  (let [summary (:policySummary (:autoPolicySummary (:retrieveAutoPolicyDetailResponse rapd-response)))
        vehicles-summary (:autoPolicySummary (:retrieveAutoPolicyDetailResponse rapd-response))
        drivers-summary (:autoPolicySummary (:retrieveAutoPolicyDetailResponse rapd-response))]    
    {:number (:policyNumber summary)
     :type (:type summary)
     :dataSource (:dataSource summary)
     :effectiveDate (:termEffectiveDate summary)
     :expirationDate (:termExpirationDate summary)
     :status (:status summary)
     :drivers (map (fn [d] (driver-model (:driver d))) (:drivers drivers-summary))
     :vehicles (map (fn [v] (vehicle-model (:vehicle v))) (:vehicles vehicles-summary))}))
  

(defn- home-policy-getter
  [policy rppd-response]
  (let [summary (:policySummary (:retrievePropertyPolicyDetailResponse rppd-response))
        dwelling (:dwelling (:retrievePropertyPolicyDetailResponse rppd-response))]
    {:number (:policyNumber summary)
     :type (:type summary)
     :dataSource (:dataSource summary)
     :effectiveDate (:termEffectiveDate summary)
     :expirationDate (:termExpirationDate summary)
     :status (:status summary)
     :address (address-model (:address dwelling))}))

(defn policies-model
  [customer]
  (soa/model customer
             constants/auto-policy-url "templates/RetrieveAutoPolicyDetails.xml" auto-policy-getter
             constants/property-policy-url "templates/RetrievePropertyPolicyDetails.xml" home-policy-getter))
