(ns billing-history.core
  (:require [clostache.parser :as clostache]
            [soa.core :as soa]
            [constants.core :as constants]
            [clojure.tools.logging :as log]))

(def ^:private template "templates/RetrievePolicyBillingHistory.xml")

(def ^:private url constants/billing-history-url)

(defn- model-mapper
  [policy model]
  {:policyNumber (:number policy) :transactions (map :accountTransaction (:accountTransactions (:retrievePolicyBillingHistoryResponse model)))})

(defn billing-history-model
  "Returns a billing history model for the requested customer.
  **See** [Data Keys page for :billing-history](/data-keys#billing-history)"
  [customer]
  (soa/model customer url template model-mapper))















