/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import org.apache.avalon.cornerstone.blocks.scheduler.BinaryHeap;
import org.apache.avalon.cornerstone.blocks.scheduler.MonitorableTimeSchedulerMBean;
import org.apache.avalon.cornerstone.blocks.scheduler.PriorityQueue;
import org.apache.avalon.cornerstone.blocks.scheduler.SynchronizedPriorityQueue;
import org.apache.avalon.cornerstone.blocks.scheduler.TimeScheduledEntry;
import org.apache.avalon.cornerstone.services.scheduler.Target;
import org.apache.avalon.cornerstone.services.scheduler.TimeScheduler;
import org.apache.avalon.cornerstone.services.scheduler.TimeTrigger;
import org.apache.avalon.cornerstone.services.scheduler.TriggerFailureListener;
import org.apache.avalon.cornerstone.services.threads.ThreadManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class DefaultTimeScheduler
extends AbstractLogEnabled
implements TimeScheduler,
Serviceable,
Startable,
Disposable,
Runnable,
MonitorableTimeSchedulerMBean {
    private final Hashtable m_entries = new Hashtable();
    private final PriorityQueue m_priorityQueue = new SynchronizedPriorityQueue(new BinaryHeap());
    private ThreadManager m_threadManager;
    private boolean m_running;
    private ArrayList m_triggerFailureListeners = new ArrayList();

    protected final ThreadManager getThreadManager() {
        return this.m_threadManager;
    }

    protected final boolean isRunning() {
        return this.m_running;
    }

    protected final void setRunning(boolean running) {
        this.m_running = running;
    }

    protected final List getTriggerFailureListeners() {
        return this.m_triggerFailureListeners;
    }

    protected final Map getEntryMap() {
        return this.m_entries;
    }

    protected final PriorityQueue getPriorityQueue() {
        return this.m_priorityQueue;
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_threadManager = (ThreadManager)serviceManager.lookup(ThreadManager.ROLE);
    }

    public void dispose() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("disposal");
        }
        this.m_entries.clear();
        this.m_priorityQueue.clear();
    }

    public void start() throws Exception {
        this.getThreadManager().getDefaultThreadPool().execute((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.m_running = false;
        DefaultTimeScheduler defaultTimeScheduler = this;
        synchronized (defaultTimeScheduler) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.m_running = true;
        while (this.m_running) {
            Object entry;
            long duration = 0L;
            if (!this.getPriorityQueue().isEmpty()) {
                entry = null;
                DefaultTimeScheduler defaultTimeScheduler = this;
                synchronized (defaultTimeScheduler) {
                    entry = this.getNextEntry();
                    if (null == entry) {
                        continue;
                    }
                    duration = ((TimeScheduledEntry)entry).getNextTime() - System.currentTimeMillis();
                    if (duration < 0L) {
                        this.getPriorityQueue().pop();
                    }
                }
                if (duration < 0L) {
                    this.runEntry((TimeScheduledEntry)entry);
                    continue;
                }
                if (0L == duration) {
                    duration = 1L;
                }
            }
            try {
                entry = this;
                synchronized (entry) {
                    this.wait(duration);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void addTriggerFailureListener(TriggerFailureListener listener) {
        this.getTriggerFailureListeners().add(listener);
    }

    public void removeTriggerFailureListener(TriggerFailureListener listener) {
        this.getTriggerFailureListeners().remove(listener);
    }

    public synchronized void addTrigger(String name, TimeTrigger trigger, Target target) {
        try {
            this.removeTrigger(name);
        }
        catch (NoSuchElementException nse) {
            // empty catch block
        }
        TimeScheduledEntry entry = new TimeScheduledEntry(name, trigger, target);
        this.getEntryMap().put(name, entry);
        boolean added = this.rescheduleEntry(entry, false);
        if (!added) {
            return;
        }
        try {
            if (entry == this.getPriorityQueue().peek()) {
                this.notifyAll();
            }
        }
        catch (NoSuchElementException nse) {
            String message = "Unexpected exception when peek() on priority queue for " + entry.getName();
            this.getLogger().warn(message, (Throwable)nse);
        }
    }

    public synchronized void removeTrigger(String name) throws NoSuchElementException {
        TimeScheduledEntry entry = this.getEntry(name);
        entry.invalidate();
        this.getEntryMap().remove(name);
    }

    public synchronized void resetTrigger(String name) throws NoSuchElementException {
        TimeScheduledEntry entry = this.getEntry(name);
        entry.getTimeTrigger().reset();
        this.rescheduleEntry(entry, true);
    }

    public synchronized Collection getEntries() {
        Set coll = this.getEntryMap().keySet();
        Vector<String> retval = new Vector<String>();
        Iterator iterator = coll.iterator();
        while (iterator.hasNext()) {
            TimeScheduledEntry tse = (TimeScheduledEntry)this.getEntryMap().get(iterator.next());
            retval.add(tse.toString());
        }
        return retval;
    }

    protected synchronized boolean rescheduleEntry(TimeScheduledEntry timeEntry, boolean clone) {
        long next;
        TimeScheduledEntry entry = timeEntry;
        if (clone) {
            entry = new TimeScheduledEntry(timeEntry.getName(), timeEntry.getTimeTrigger(), timeEntry.getTarget());
            timeEntry.invalidate();
            this.getEntryMap().remove(timeEntry.getName());
            this.getEntryMap().put(timeEntry.getName(), entry);
        }
        if (0L < (next = entry.getTimeTrigger().getTimeAfter(System.currentTimeMillis()))) {
            entry.setNextTime(next);
            this.getPriorityQueue().insert(entry);
            if (entry == this.getPriorityQueue().peek()) {
                this.notify();
            }
            return true;
        }
        return false;
    }

    protected TimeScheduledEntry getEntry(String name) throws NoSuchElementException {
        TimeScheduledEntry entry = (TimeScheduledEntry)this.getEntryMap().get(name);
        if (null != entry) {
            return entry;
        }
        throw new NoSuchElementException();
    }

    protected void runEntry(final TimeScheduledEntry entry) {
        Runnable runnable = new Runnable(){

            public void run() {
                DefaultTimeScheduler.this.doRunEntry(entry);
            }
        };
        try {
            this.getThreadManager().getDefaultThreadPool().execute(runnable);
        }
        catch (Exception e) {
            String message = "Error executing trigger " + entry.getName();
            this.getLogger().warn(message, (Throwable)e);
        }
        this.rescheduleEntry(entry, false);
    }

    protected void doRunEntry(TimeScheduledEntry entry) {
        try {
            entry.getTarget().targetTriggered(entry.getName());
        }
        catch (Error e) {
            String message = "Error occured executing trigger " + entry.getName();
            this.getLogger().error(message, (Throwable)e);
            this.notifyFailedTriggers(e);
        }
        catch (Exception e) {
            String message = "Exception occured executing trigger " + entry.getName();
            this.getLogger().warn(message, (Throwable)e);
            this.notifyFailedTriggers(e);
        }
    }

    protected synchronized TimeScheduledEntry getNextEntry() {
        TimeScheduledEntry entry = (TimeScheduledEntry)this.getPriorityQueue().peek();
        while (!entry.isValid()) {
            this.getPriorityQueue().pop();
            if (this.getPriorityQueue().isEmpty()) {
                return null;
            }
            entry = (TimeScheduledEntry)this.getPriorityQueue().peek();
        }
        return entry;
    }

    protected void notifyFailedTriggers(Throwable t) {
        for (int i = 0; i < this.getTriggerFailureListeners().size(); ++i) {
            TriggerFailureListener triggerFailureListener = (TriggerFailureListener)this.m_triggerFailureListeners.get(i);
            triggerFailureListener.triggerFailure(t);
        }
    }
}

