/*
 * Decompiled with CFR 0.152.
 */
package org.controlhaus.xfire.client;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.beehive.controls.api.bean.ControlImplementation;
import org.apache.beehive.controls.api.bean.Extensible;
import org.apache.beehive.controls.api.context.Context;
import org.apache.beehive.controls.api.context.ControlBeanContext;
import org.apache.beehive.controls.api.context.ResourceContext;
import org.apache.beehive.controls.api.events.Client;
import org.apache.beehive.controls.api.events.EventHandler;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.codehaus.xfire.client.ClientHandler;
import org.codehaus.xfire.client.http.SoapHttpClient;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.xmlbeans.client.XMLBeansClientHandler;
import org.controlhaus.xfire.client.XFireClientControl;

@ControlImplementation
public class XFireClientControlImpl
implements XFireClientControl,
Extensible {
    @Context
    ControlBeanContext context;
    @Context
    ResourceContext resourceContext;
    @Client
    XFireClientControl.EndInvokeCallback callback;
    private String encoding;
    private String serviceUrl;
    private XmlOptions options;
    private SoapHttpClient client;

    @EventHandler(field="resourceContext", eventSet=ResourceContext.ResourceEvents.class, eventName="onAcquire")
    public void onAcquire() {
        XFireClientControl.Encoding encProp;
        this.options = new XmlOptions();
        this.options.setCharacterEncoding(this.getEncoding());
        XFireClientControl.ServiceUrl destProp = (XFireClientControl.ServiceUrl)this.context.getControlPropertySet(XFireClientControl.ServiceUrl.class);
        if (destProp != null) {
            this.serviceUrl = destProp.value();
        }
        if ((encProp = (XFireClientControl.Encoding)this.context.getControlPropertySet(XFireClientControl.Encoding.class)) != null) {
            this.encoding = encProp.value();
        }
    }

    public XmlObject[] invoke(XmlObject[] request) throws IOException, XFireFault {
        return this.invoke(request, null);
    }

    public XmlObject[] invoke(XmlObject[] request, XmlObject[] reqHeaders) throws IOException, XFireFault {
        XMLBeansClientHandler handler = new XMLBeansClientHandler(this.options);
        handler.setRequest(request);
        XMLBeansClientHandler headHandler = new XMLBeansClientHandler(this.options);
        headHandler.setRequest(reqHeaders);
        SoapHttpClient client = new SoapHttpClient((ClientHandler)handler, (ClientHandler)headHandler, this.getServiceUrl());
        client.invoke();
        return handler.getResponse();
    }

    public void beginInvoke(XmlObject[] request, XmlObject[] reqHeaders) {
        ServiceInvokerThread thread = new ServiceInvokerThread(request, reqHeaders, this.options, this.getServiceUrl(), this.callback);
        thread.run();
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public ClientHandler getHeaderHandler() {
        return null;
    }

    public Object invoke(Method m, Object[] args) throws Throwable {
        if (this.getServiceUrl() == null) {
            XFireClientControl.ServiceUrl a = m.getDeclaringClass().getAnnotation(XFireClientControl.ServiceUrl.class);
            this.serviceUrl = a.value();
        }
        ArrayList<XmlObject> reqArgs = new ArrayList<XmlObject>(args.length);
        ArrayList<XmlObject> headerArgs = new ArrayList<XmlObject>();
        for (int i = 0; i < args.length; ++i) {
            if (this.isSoapHeader(m, i)) {
                headerArgs.add((XmlObject)args[i]);
                continue;
            }
            reqArgs.add((XmlObject)args[i]);
        }
        XmlObject[] arr = reqArgs.toArray(new XmlObject[reqArgs.size()]);
        XmlObject[] headers = headerArgs.toArray(new XmlObject[headerArgs.size()]);
        if (!m.isAnnotationPresent(XFireClientControl.Asynchronous.class)) {
            if (m.getReturnType().isArray()) {
                return this.invoke(arr, headers);
            }
            return this.invoke(arr, headers)[0];
        }
        this.beginInvoke(arr, headers);
        return null;
    }

    private boolean isSoapHeader(Method m, int i) {
        Annotation[] annots = m.getParameterAnnotations()[i];
        for (int j = 0; j < annots.length; ++j) {
            if (!annots[j].annotationType().equals(XFireClientControl.SoapHeader.class)) continue;
            return true;
        }
        return false;
    }

    public class ServiceInvokerThread
    extends Thread {
        private XFireClientControl.EndInvokeCallback callback;
        private SoapHttpClient client;
        private XMLBeansClientHandler handler;
        private XMLBeansClientHandler headHandler;

        public ServiceInvokerThread(XmlObject[] request, XmlObject[] reqHeaders, XmlOptions options, String serviceUrl, XFireClientControl.EndInvokeCallback callback) {
            if (callback == null) {
                throw new IllegalArgumentException("Callback cannot be null.");
            }
            this.callback = callback;
            this.handler = new XMLBeansClientHandler(options);
            this.handler.setRequest(request);
            this.headHandler = new XMLBeansClientHandler(options);
            this.headHandler.setRequest(reqHeaders);
            this.client = new SoapHttpClient((ClientHandler)this.handler, (ClientHandler)this.headHandler, XFireClientControlImpl.this.getServiceUrl());
        }

        public void run() {
            try {
                this.client.invoke();
                this.callback.endInvoke(this.handler.getResponse(), this.headHandler.getResponse());
            }
            catch (IOException e) {
                this.callback.handleFault(new XFireFault("Couldn't connect to the service.", (Throwable)e, "Sender"));
            }
            catch (XFireFault fault) {
                this.callback.handleFault(fault);
            }
        }
    }
}

