/*
 * Decompiled with CFR 0.152.
 */
package org.controlhaus.jms.impl;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import org.apache.beehive.controls.api.ControlException;
import org.apache.beehive.controls.api.bean.Control;
import org.apache.beehive.controls.api.bean.ControlImplementation;
import org.apache.beehive.controls.api.bean.Extensible;
import org.apache.beehive.controls.api.context.Context;
import org.apache.beehive.controls.api.context.ControlBeanContext;
import org.apache.beehive.controls.api.context.ResourceContext;
import org.apache.beehive.controls.api.events.EventHandler;
import org.apache.xmlbeans.XmlObject;
import org.controlhaus.jms.JMSControl;
import org.controlhaus.jndi.JndiControlBean;

@ControlImplementation
public class JMSControlImpl
implements JMSControl,
Extensible {
    @Context
    private ResourceContext _resourceContext;
    @Context
    private ControlBeanContext _context;
    @Control
    private JndiControlBean _jndiControl;
    private transient Destination _destination;
    private transient JMSControl.DestinationType _destinationType = JMSControl.DestinationType.Auto;
    private transient Connection _connection;
    private transient Session _session;
    private transient MessageProducer _producer;
    private boolean _jndiInitialized;
    private Map<JMSControl.HeaderType, Object> _headers;
    private Map<String, Object> _properties;

    public Session getSession() throws ControlException {
        if (this._session == null) {
            try {
                switch (this.getDestinationType()) {
                    case Auto: {
                        try {
                            this.createQueueSession();
                        }
                        catch (JMSException e) {
                            this.createTopicSession();
                        }
                        break;
                    }
                    case Topic: {
                        this.createTopicSession();
                        break;
                    }
                    case Queue: {
                        this.createQueueSession();
                    }
                }
            }
            catch (JMSException e) {
                throw new ControlException("Failure to get JMS connection or session", (Throwable)e);
            }
        }
        return this._session;
    }

    public Destination getDestination() throws ControlException {
        if (this._destination == null) {
            this._destination = (Destination)this.getJndiControl().getResource(this.getDestinationProperties().sendJndiName(), Destination.class);
        }
        return this._destination;
    }

    public Connection getConnection() throws ControlException {
        this.getSession();
        return this._connection;
    }

    public void setHeaders(Map headers) {
        for (Object name : headers.keySet()) {
            Object value = headers.get(name);
            JMSControl.HeaderType type = null;
            if (!(name instanceof JMSControl.HeaderType)) {
                if (name.equals(JMSControl.HeaderType.JMSCorrelationID.toString())) {
                    type = JMSControl.HeaderType.JMSCorrelationID;
                } else if (name.equals(JMSControl.HeaderType.JMSDeliveryMode.toString())) {
                    type = JMSControl.HeaderType.JMSDeliveryMode;
                } else if (name.equals(JMSControl.HeaderType.JMSExpiration.toString())) {
                    type = JMSControl.HeaderType.JMSExpiration;
                } else if (name.equals(JMSControl.HeaderType.JMSMessageID.toString())) {
                    type = JMSControl.HeaderType.JMSMessageID;
                } else if (name.equals(JMSControl.HeaderType.JMSPriority.toString())) {
                    type = JMSControl.HeaderType.JMSPriority;
                } else if (name.equals(JMSControl.HeaderType.JMSRedelivered.toString())) {
                    type = JMSControl.HeaderType.JMSRedelivered;
                } else if (name.equals(JMSControl.HeaderType.JMSTimestamp.toString())) {
                    type = JMSControl.HeaderType.JMSTimestamp;
                } else if (name.equals(JMSControl.HeaderType.JMSType.toString())) {
                    type = JMSControl.HeaderType.JMSType;
                } else {
                    throw new IllegalArgumentException("Invalid JMS header type '" + name + "'");
                }
            }
            headers.put(type, value);
        }
    }

    public void setHeader(JMSControl.HeaderType type, Object value) {
        if (this._headers == null) {
            this._headers = new HashMap<JMSControl.HeaderType, Object>();
        }
        this._headers.put(type, value);
    }

    public void setProperties(Map properties) {
        for (String name : properties.keySet()) {
            Object value = properties.get(name);
            this.setProperty(name, value);
        }
    }

    public void setProperty(String name, Object value) {
        if (this._properties == null) {
            this._properties = new HashMap<String, Object>();
        }
        this._properties.put(name, value);
    }

    public Object invoke(Method method, Object[] args) throws ControlException {
        assert (method != null && args != null);
        Message m = null;
        boolean isBody = false;
        try {
            JMSControl.Properties jmsProps;
            JMSControl.CorrelationId id;
            JMSControl.Type t;
            JMSControl.Delivery del;
            JMSControl.Expiration exp;
            Long l;
            Integer v;
            JMSControl.Destination props = this.getDestinationProperties();
            Session session = this.getSession();
            String jmsType = null;
            String correlationId = null;
            int deliveryMode = this.getProducer().getDeliveryMode();
            int priority = this.getProducer().getPriority();
            long expiration = this.getProducer().getTimeToLive();
            Object mode = this.getHeader(JMSControl.HeaderType.JMSDeliveryMode);
            if (mode != null) {
                deliveryMode = this.deliveryModeToJmsMode(mode);
            }
            if ((v = this.getHeaderAsInteger(JMSControl.HeaderType.JMSPriority)) != null) {
                priority = v;
            }
            if ((l = this.getHeaderAsLong(JMSControl.HeaderType.JMSExpiration)) != null) {
                expiration = l;
            }
            Object body = null;
            for (int i = 0; i < args.length; ++i) {
                if (this._context.getParameterPropertySet(method, i, JMSControl.Priority.class) != null || this._context.getParameterPropertySet(method, i, JMSControl.Property.class) != null || this._context.getParameterPropertySet(method, i, JMSControl.Expiration.class) != null || this._context.getParameterPropertySet(method, i, JMSControl.Delivery.class) != null || this._context.getParameterPropertySet(method, i, JMSControl.Type.class) != null || this._context.getParameterPropertySet(method, i, JMSControl.CorrelationId.class) != null) continue;
                if (isBody) {
                    throw new IllegalArgumentException("At most one parameter may be defined as the body of the JMS message");
                }
                body = args[i];
                isBody = true;
            }
            JMSControl.Priority pri = (JMSControl.Priority)this._context.getMethodPropertySet(method, JMSControl.Priority.class);
            if (pri != null && pri.value() != -1) {
                priority = pri.value();
            }
            if ((exp = (JMSControl.Expiration)this._context.getMethodPropertySet(method, JMSControl.Expiration.class)) != null && exp.value() != -1L) {
                expiration = exp.value();
            }
            if ((del = (JMSControl.Delivery)this._context.getMethodPropertySet(method, JMSControl.Delivery.class)) != null && del.value() != JMSControl.DeliveryMode.Auto) {
                deliveryMode = this.deliveryModeToJmsMode((Object)del.value());
            }
            if ((t = (JMSControl.Type)this._context.getMethodPropertySet(method, JMSControl.Type.class)) != null && t.value().length() != 0) {
                jmsType = t.value();
            }
            if ((id = (JMSControl.CorrelationId)this._context.getMethodPropertySet(method, JMSControl.CorrelationId.class)) != null && id.value().length() != 0) {
                correlationId = id.value();
            }
            JMSControl.Message mess = (JMSControl.Message)this._context.getMethodPropertySet(method, JMSControl.Message.class);
            JMSControl.MessageType type = JMSControl.MessageType.Auto;
            if (mess != null) {
                type = mess.value();
            }
            if (type.equals((Object)JMSControl.MessageType.Auto)) {
                if (body instanceof byte[]) {
                    type = JMSControl.MessageType.Bytes;
                } else if (body instanceof Map || !isBody) {
                    type = JMSControl.MessageType.Map;
                } else if (body instanceof String || body instanceof XmlObject) {
                    type = JMSControl.MessageType.Text;
                } else if (body instanceof Message) {
                    type = JMSControl.MessageType.JMSMessage;
                } else if (body instanceof Serializable) {
                    type = JMSControl.MessageType.Object;
                } else {
                    throw new ControlException("Cannot determine message type from body");
                }
            }
            switch (type) {
                case Object: {
                    this.checkBody(body, Serializable.class);
                    m = session.createObjectMessage((Serializable)body);
                    break;
                }
                case Bytes: {
                    this.checkBody(body, byte[].class);
                    StreamMessage sm = session.createStreamMessage();
                    m = sm;
                    sm.writeBytes((byte[])body);
                    break;
                }
                case Text: {
                    if (body instanceof XmlObject) {
                        body = ((XmlObject)body).xmlText();
                    }
                    this.checkBody(body, String.class);
                    m = session.createTextMessage((String)body);
                    break;
                }
                case Map: {
                    this.checkBody(body, Map.class);
                    MapMessage mm = session.createMapMessage();
                    m = mm;
                    Map map = (Map)body;
                    for (String key : map.keySet()) {
                        mm.setObject(key, map.get(key));
                    }
                    break;
                }
                case JMSMessage: {
                    this.checkBody(body, Message.class);
                    m = (Message)body;
                }
            }
            String correlationProp = props.sendCorrelationProperty();
            if (correlationProp != null && correlationId.length() == 0) {
                correlationProp = null;
            }
            if (correlationId == null) {
                correlationId = this.getHeaderAsString(JMSControl.HeaderType.JMSCorrelationID);
            }
            if ((jmsProps = (JMSControl.Properties)this._context.getMethodPropertySet(method, JMSControl.Properties.class)) != null) {
                JMSControl.PropertyValue[] jprops = jmsProps.value();
                for (int i = 0; i < jprops.length; ++i) {
                    JMSControl.PropertyValue jprop = jprops[i];
                    Class cls = jprop.type();
                    if (cls.equals(String.class)) {
                        m.setStringProperty(jprop.name(), jprop.value());
                        continue;
                    }
                    if (cls.equals(Integer.class)) {
                        m.setIntProperty(jprop.name(), this.valueAsInteger(jprop.value()).intValue());
                        continue;
                    }
                    if (cls.equals(Long.class)) {
                        m.setLongProperty(jprop.name(), this.valueAsLong(jprop.value()).longValue());
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid type for property-value");
                }
            }
            for (int i = 0; i < args.length; ++i) {
                JMSControl.CorrelationId jmsId;
                JMSControl.Delivery jmsDelivery;
                Long e;
                JMSControl.Expiration jmsExpiration;
                Integer p;
                JMSControl.Priority jmsPriority;
                JMSControl.Property jmsProp = (JMSControl.Property)this._context.getParameterPropertySet(method, i, JMSControl.Property.class);
                if (jmsProp != null) {
                    m.setObjectProperty(jmsProp.name(), args[i]);
                }
                if ((jmsPriority = (JMSControl.Priority)this._context.getParameterPropertySet(method, i, JMSControl.Priority.class)) != null && (p = this.valueAsInteger(args[i])) != null) {
                    priority = p;
                }
                if ((jmsExpiration = (JMSControl.Expiration)this._context.getParameterPropertySet(method, i, JMSControl.Expiration.class)) != null && (e = this.valueAsLong(args[i])) != null) {
                    expiration = e;
                }
                if ((jmsDelivery = (JMSControl.Delivery)this._context.getParameterPropertySet(method, i, JMSControl.Delivery.class)) != null && args[i] != null) {
                    deliveryMode = this.deliveryModeToJmsMode(args[i]);
                }
                if ((t = (JMSControl.Type)this._context.getParameterPropertySet(method, i, JMSControl.Type.class)) != null && args[i] != null) {
                    jmsType = (String)args[i];
                }
                if ((jmsId = (JMSControl.CorrelationId)this._context.getParameterPropertySet(method, i, JMSControl.CorrelationId.class)) == null || args[i] == null) continue;
                correlationId = (String)args[i];
            }
            if (correlationProp != null) {
                m.setStringProperty(correlationProp, correlationId);
            } else {
                m.setJMSCorrelationID(correlationId);
            }
            this.setMessageHeaders(m);
            this.setMessageProperties(m);
            this._headers = null;
            this._properties = null;
            switch (this.getDestinationType()) {
                case Topic: {
                    ((TopicPublisher)this.getProducer()).publish(m, deliveryMode, priority, expiration);
                    break;
                }
                case Queue: {
                    ((QueueSender)this.getProducer()).send(m, deliveryMode, priority, expiration);
                }
            }
        }
        catch (JMSException e) {
            throw new ControlException("Error in sending message", (Throwable)e);
        }
        return m;
    }

    @EventHandler(field="_resourceContext", eventSet=ResourceContext.ResourceEvents.class, eventName="onAcquire")
    public void onAcquire() {
    }

    @EventHandler(field="_resourceContext", eventSet=ResourceContext.ResourceEvents.class, eventName="onRelease")
    public void onRelease() {
        try {
            if (this._producer != null) {
                this._producer.close();
                this._producer = null;
            }
            if (this._session != null) {
                this._session.close();
                this._session = null;
            }
            if (this._connection != null) {
                this._connection.close();
                this._connection = null;
            }
        }
        catch (JMSException jmse) {
            throw new ControlException("Unable to release JMS resource", (Throwable)jmse);
        }
    }

    protected MessageProducer getProducer() {
        if (this._producer == null) {
            try {
                Session sess = this.getSession();
                switch (this.getDestinationType()) {
                    case Topic: {
                        this._producer = ((TopicSession)sess).createPublisher((Topic)this.getDestination());
                        break;
                    }
                    case Queue: {
                        this._producer = ((QueueSession)sess).createSender((Queue)this.getDestination());
                    }
                }
            }
            catch (JMSException jmse) {
                throw new ControlException("Unable to acquire JMS resource", (Throwable)jmse);
            }
        }
        return this._producer;
    }

    protected void createTopicSession() throws JMSException {
        JMSControl.Destination props = this.getDestinationProperties();
        String factory = props.jndiConnectionFactory();
        boolean transacted = props.transacted();
        JMSControl.AcknowledgeMode ackMode = props.acknowledgeMode();
        this._destinationType = JMSControl.DestinationType.Queue;
        TopicConnectionFactory connFactory = (TopicConnectionFactory)this.getJndiControl().getResource(factory, TopicConnectionFactory.class);
        this._connection = connFactory.createTopicConnection();
        this._session = ((TopicConnection)this._connection).createTopicSession(transacted, this.modeToJmsMode(ackMode));
    }

    protected void createQueueSession() throws JMSException {
        JMSControl.Destination props = this.getDestinationProperties();
        String factory = props.jndiConnectionFactory();
        boolean transacted = props.transacted();
        JMSControl.AcknowledgeMode ackMode = props.acknowledgeMode();
        this._destinationType = JMSControl.DestinationType.Queue;
        QueueConnectionFactory connFactory = (QueueConnectionFactory)this.getJndiControl().getResource(factory, QueueConnectionFactory.class);
        this._connection = connFactory.createQueueConnection();
        this._session = ((QueueConnection)this._connection).createQueueSession(transacted, this.modeToJmsMode(ackMode));
    }

    protected int modeToJmsMode(JMSControl.AcknowledgeMode mode) {
        if (mode == JMSControl.AcknowledgeMode.Auto) {
            return 1;
        }
        if (mode == JMSControl.AcknowledgeMode.Client) {
            return 2;
        }
        return 3;
    }

    protected int deliveryModeToJmsMode(Object value) {
        if (value instanceof JMSControl.DeliveryMode) {
            JMSControl.DeliveryMode mode = (JMSControl.DeliveryMode)((Object)value);
            switch (mode) {
                case Persistent: {
                    return 2;
                }
                case NonPersistent: {
                    return 1;
                }
            }
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        throw new IllegalArgumentException("Invalid delivery mode value");
    }

    protected void checkBody(Object value, Class cls) throws ControlException {
        if (!cls.isInstance(value)) {
            throw new ControlException("Message body is not of correct type expected " + cls.getName());
        }
    }

    protected JMSControl.Destination getDestinationProperties() {
        return (JMSControl.Destination)this._context.getControlPropertySet(JMSControl.Destination.class);
    }

    protected JMSControl.DestinationType getDestinationType() throws ControlException {
        if (this._destinationType != JMSControl.DestinationType.Auto) {
            return this._destinationType;
        }
        JMSControl.Destination d = this.getDestinationProperties();
        if (d.sendType() != JMSControl.DestinationType.Auto) {
            this._destinationType = d.sendType();
        }
        return d.sendType();
    }

    protected void setMessageProperties(Message msg) throws ControlException {
        if (this._properties == null) {
            return;
        }
        for (String name : this._properties.keySet()) {
            Object value = this._properties.get(name);
            try {
                msg.setObjectProperty(name, value);
            }
            catch (JMSException e) {
                throw new ControlException("Cannot set property '" + name + "' into JMS message");
            }
        }
    }

    protected void setMessageHeaders(Message msg) throws ControlException {
        if (this._headers == null) {
            return;
        }
        for (JMSControl.HeaderType name : this._headers.keySet()) {
            Object value = this._headers.get((Object)name);
            this.setMessageHeader(msg, name, value);
        }
    }

    protected void setMessageHeader(Message msg, JMSControl.HeaderType type, Object value) {
        switch (type) {
            case JMSMessageID: {
                try {
                    msg.setJMSMessageID((String)value);
                    break;
                }
                catch (JMSException e) {
                    throw new ControlException("Error setting JMSMessageID for message", (Throwable)e);
                }
            }
            case JMSRedelivered: {
                try {
                    if (value instanceof Boolean) {
                        msg.setJMSRedelivered(((Boolean)value).booleanValue());
                        break;
                    }
                    if (!(value instanceof String)) break;
                    msg.setJMSRedelivered(Boolean.getBoolean((String)value));
                    break;
                }
                catch (JMSException e) {
                    throw new ControlException("Error setting JMSRedelivered for message", (Throwable)e);
                }
            }
            case JMSTimestamp: {
                try {
                    if (value instanceof Long) {
                        msg.setJMSTimestamp(((Long)value).longValue());
                        break;
                    }
                    if (!(value instanceof String)) break;
                    msg.setJMSTimestamp(Long.parseLong((String)value));
                    break;
                }
                catch (JMSException e) {
                    throw new ControlException("Error setting JMSTimestamp for message", (Throwable)e);
                }
            }
            case JMSType: {
                try {
                    msg.setJMSType((String)value);
                    break;
                }
                catch (JMSException e) {
                    throw new ControlException("Error setting JMSType for message", (Throwable)e);
                }
            }
        }
    }

    protected Object getHeader(JMSControl.HeaderType name) {
        if (this._headers == null) {
            return null;
        }
        return this._headers.get(name.toString());
    }

    protected String getHeaderAsString(JMSControl.HeaderType name) {
        Object obj = this.getHeader(name);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    protected Integer getHeaderAsInteger(JMSControl.HeaderType name) {
        Object obj = this.getHeader(name);
        return this.valueAsInteger(this.getHeader(name));
    }

    protected Integer valueAsInteger(Object obj) {
        if (obj instanceof String) {
            return Integer.parseInt((String)obj);
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof Number) {
            return new Integer(((Number)obj).intValue());
        }
        return null;
    }

    protected Long getHeaderAsLong(JMSControl.HeaderType name) {
        return this.valueAsLong(this.getHeader(name));
    }

    protected Long valueAsLong(Object obj) {
        if (obj instanceof String) {
            return Long.parseLong((String)obj);
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof Number) {
            return new Long(((Number)obj).longValue());
        }
        return null;
    }

    protected JndiControlBean getJndiControl() {
        if (!this._jndiInitialized) {
            this._jndiInitialized = true;
            JMSControl.Destination dest = this.getDestinationProperties();
            if (dest.jndiContextFactory() != null && dest.jndiContextFactory().length() != 0) {
                this._jndiControl.setFactory(dest.jndiContextFactory());
            }
            if (dest.jndiProviderURL() != null && dest.jndiProviderURL().length() != 0) {
                this._jndiControl.setUrl(dest.jndiProviderURL());
            }
        }
        return this._jndiControl;
    }
}

