/*
 * Decompiled with CFR 0.152.
 */
package org.controlhaus.jms;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.Session;
import org.apache.beehive.controls.api.ControlException;
import org.apache.beehive.controls.api.bean.AnnotationConstraints;
import org.apache.beehive.controls.api.bean.AnnotationMemberTypes;
import org.apache.beehive.controls.api.bean.ControlInterface;
import org.apache.beehive.controls.api.packaging.FeatureInfo;
import org.apache.beehive.controls.api.properties.PropertySet;

@ControlInterface(defaultBinding="org.controlhaus.jms.impl.JMSControlImpl")
public interface JMSControl {
    public static final String HEADER_CORRELATIONID = HeaderType.JMSCorrelationID.toString();
    public static final String HEADER_DELIVERYMODE = HeaderType.JMSDeliveryMode.toString();
    public static final String HEADER_EXPIRATION = HeaderType.JMSExpiration.toString();
    public static final String HEADER_MESSAGEID = HeaderType.JMSMessageID.toString();
    public static final String HEADER_PRIORITY = HeaderType.JMSPriority.toString();
    public static final String HEADER_REDELIVERED = HeaderType.JMSRedelivered.toString();
    public static final String HEADER_TIMESTAMP = HeaderType.JMSTimestamp.toString();
    public static final String HEADER_TYPE = HeaderType.JMSType.toString();

    public Session getSession() throws ControlException;

    public Connection getConnection() throws ControlException;

    public javax.jms.Destination getDestination() throws ControlException;

    public void setHeaders(Map var1);

    public void setHeader(HeaderType var1, Object var2);

    public void setProperties(Map var1);

    public void setProperty(String var1, Object var2);

    @PropertySet
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.FIELD})
    @AnnotationConstraints.AllowExternalOverride
    public static @interface Destination {
        @AnnotationMemberTypes.JndiName(resourceType=AnnotationMemberTypes.JndiName.ResourceType.OTHER)
        @FeatureInfo(shortDescription="JNDI name of the queue or topic")
        public String sendJndiName();

        @AnnotationMemberTypes.Optional
        @FeatureInfo(shortDescription="Correlation-Id for messages")
        public String sendCorrelationProperty() default "";

        @FeatureInfo(shortDescription="JNDI name of queue connection factory")
        public String jndiConnectionFactory();

        @AnnotationMemberTypes.Optional
        @FeatureInfo(shortDescription="The destination type (DestinationType). The default is to use the type of the destination object named by the JNDI name")
        public DestinationType sendType() default DestinationType.Auto;

        @AnnotationMemberTypes.Optional
        @FeatureInfo(shortDescription="True if send is transacted. The default is transacted")
        public boolean transacted() default true;

        @AnnotationMemberTypes.Optional
        @FeatureInfo(shortDescription="The acknowledge mode. The default is to use auto-acknowledge")
        public AcknowledgeMode acknowledgeMode() default AcknowledgeMode.Auto;

        @AnnotationMemberTypes.Optional
        @FeatureInfo(shortDescription="JNDI context factory")
        public String jndiContextFactory() default "";

        @AnnotationMemberTypes.Optional
        @AnnotationMemberTypes.URL
        @FeatureInfo(shortDescription="JNDI provider URL")
        public String jndiProviderURL() default "";
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Properties {
        public PropertyValue[] value();
    }

    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Delivery {
        public DeliveryMode value() default DeliveryMode.Auto;
    }

    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @AnnotationConstraints.AllowExternalOverride
    public static @interface Expiration {
        @AnnotationMemberTypes.Optional
        public long value() default -1L;
    }

    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface CorrelationId {
        public String value() default "";
    }

    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Type {
        public String value() default "";
    }

    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @AnnotationConstraints.AllowExternalOverride
    public static @interface Priority {
        @AnnotationMemberTypes.Optional
        public int value() default -1;
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface PropertyValue {
        public String name();

        public String value();

        public Class type() default String.class;
    }

    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Property {
        public String name();
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Message {
        @FeatureInfo(shortDescription="The message type")
        public MessageType value() default MessageType.Auto;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AcknowledgeMode {
        Auto,
        Client,
        DupsOk;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DeliveryMode {
        NonPersistent,
        Persistent,
        Auto;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageType {
        Auto,
        Text,
        Bytes,
        Object,
        Map,
        JMSMessage;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HeaderType {
        JMSCorrelationID,
        JMSDeliveryMode,
        JMSPriority,
        JMSExpiration,
        JMSMessageID,
        JMSType,
        JMSRedelivered,
        JMSTimestamp;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DestinationType {
        Auto,
        Queue,
        Topic;

    }
}

