/*
 * Decompiled with CFR 0.152.
 */
package org.controlhaus.hibernate;

import java.io.File;
import java.net.URL;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;
import org.apache.log4j.Logger;
import org.controlhaus.hibernate.HibernateControl;

public class HibernateFactory {
    private static Logger logger = Logger.getLogger((String)HibernateFactory.class.getName());
    private static HibernateFactory factory = new HibernateFactory();
    private String location = "/hibernate.cfg.xml";
    private SessionFactory sessionFactory;

    public SessionFactory getSessionFactory(HibernateControl control) {
        if (this.sessionFactory == null) {
            this.sessionFactory = this.createSessionFactory();
        }
        return this.sessionFactory;
    }

    private SessionFactory createSessionFactory() {
        logger.info((Object)"Initializing Hibernate.");
        Configuration hibConfig = new Configuration();
        try {
            String mapping = System.getProperty("hibernate.cfg.xml");
            if (mapping == null || mapping.equals("")) {
                mapping = this.location;
            }
            logger.debug((Object)("Configuration mapping " + mapping));
            File file = new File(mapping);
            if (file.exists()) {
                hibConfig.configure(file);
            } else {
                URL url = this.getClass().getResource(mapping);
                if (url != null) {
                    hibConfig.configure(url);
                } else {
                    logger.error((Object)("Couldn't find mapping file: " + mapping));
                    throw new RuntimeException("Couldn't find mapping file: " + mapping);
                }
            }
            return hibConfig.buildSessionFactory();
        }
        catch (HibernateException e) {
            logger.error((Object)"Mapping problem.", (Throwable)e);
            throw new RuntimeException("Mapping problem.", e);
        }
    }

    public static HibernateFactory getInstance() {
        return factory;
    }
}

