/*
 * Decompiled with CFR 0.152.
 */
package org.controlhaus.hibernate;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;
import org.apache.log4j.Logger;
import org.controlhaus.hibernate.HibernateControl;

public class HibernateFactory {
    private static Logger logger = Logger.getLogger((String)HibernateFactory.class.getName());
    private Map<String, SessionFactory> factories = new HashMap<String, SessionFactory>();
    private static HibernateFactory factory = new HibernateFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionFactory getSessionFactory(HibernateControl control) {
        String name = control.getHibernateInstance();
        SessionFactory factory = this.factories.get(name);
        if (factory == null) {
            Map<String, SessionFactory> map = this.factories;
            synchronized (map) {
                factory = this.initializeHibernate(control);
                this.factories.put(name, factory);
            }
        }
        return factory;
    }

    private synchronized SessionFactory initializeHibernate(HibernateControl control) {
        logger.info((Object)("Initializing Hibernate instance " + control.getHibernateInstance() + "."));
        Configuration hibConfig = new Configuration();
        try {
            String mapping = control.getConfigurationLocation();
            logger.debug((Object)("Configuration mapping " + mapping));
            File file = new File(mapping);
            if (file.exists()) {
                hibConfig.configure(file);
            } else {
                URL url = this.getClass().getResource(mapping);
                if (url != null) {
                    hibConfig.configure(url);
                } else {
                    logger.error((Object)("Couldn't find mapping file: " + mapping));
                    throw new RuntimeException("Couldn't find mapping file: " + mapping);
                }
            }
            return hibConfig.buildSessionFactory();
        }
        catch (HibernateException e) {
            logger.error((Object)"Mapping problem.", (Throwable)e);
            throw new RuntimeException("Mapping problem.", e);
        }
    }

    public static HibernateFactory getInstance() {
        return factory;
    }
}

