/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.util.iterator;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.beehive.netui.util.Bundle;
import org.apache.beehive.netui.util.logging.Logger;

public class ResultSetIterator
implements Iterator {
    private static final Logger _logger = Logger.getInstance(ResultSetIterator.class);
    private ResultSet _rs = null;
    private boolean _calledHasNext = false;
    private boolean _hasNext = false;
    private String[] _columnNames = null;

    public ResultSetIterator(ResultSet rs) {
        assert (rs != null);
        this._rs = rs;
        try {
            ResultSetMetaData _rsmd = this._rs.getMetaData();
            assert (_rsmd != null);
            int cols = _rsmd.getColumnCount();
            this._columnNames = new String[cols];
            for (int i = 1; i <= cols; ++i) {
                String col = _rsmd.getColumnName(i);
                if (_logger.isDebugEnabled()) {
                    _logger.debug("found column: " + col);
                }
                this._columnNames[i - 1] = col;
            }
        }
        catch (SQLException sql) {
            if (_logger.isErrorEnabled()) {
                _logger.error("An exception occurred reading ResultSetMetaData from a ResultSet.  Cause: " + sql, sql);
            }
            throw new RuntimeException("An exception occurred reading ResultSetMetaData from a ResultSet.  Cause: " + sql, sql);
        }
    }

    public boolean hasNext() {
        if (!this._calledHasNext) {
            this._calledHasNext = true;
            try {
                this._hasNext = this._rs.next();
            }
            catch (SQLException sql) {
                if (_logger.isErrorEnabled()) {
                    _logger.error("An exception occurred reading from a ResultSet.  Cause: " + sql, sql);
                }
                throw new RuntimeException("An exception occurred reading from a ResultSet.  Cause: " + sql, sql);
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("hasNext: " + this._hasNext);
        }
        return this._hasNext;
    }

    public Object next() {
        if (!this._hasNext) {
            throw new NoSuchElementException(Bundle.getErrorString("IteratorFactory_Iterator_noSuchElement"));
        }
        if (!this._calledHasNext) {
            try {
                this._hasNext = this._rs.next();
            }
            catch (SQLException sql) {
                if (_logger.isErrorEnabled()) {
                    _logger.error("An exception occurred reading from a ResultSet.  Cause: " + sql, sql);
                }
                throw new RuntimeException("An exception occurred reading from a ResultSet.  Cause: " + sql, sql);
            }
            if (!this._hasNext) {
                throw new NoSuchElementException(Bundle.getErrorString("IteratorFactory_Iterator_noSuchElement"));
            }
        }
        this._calledHasNext = false;
        HashMap<String, Object> row = new HashMap<String, Object>();
        assert (this._columnNames != null);
        for (int i = 0; i < this._columnNames.length; ++i) {
            String key = this._columnNames[i];
            try {
                Object value = this._rs.getObject(key);
                row.put(key, value);
                continue;
            }
            catch (SQLException sql) {
                if (_logger.isErrorEnabled()) {
                    _logger.error("An exception occurred reading from a ResultSet.  Cause: " + sql, sql);
                }
                throw new RuntimeException("An exception occurred reading from a ResultSet.  Cause: " + sql, sql);
            }
        }
        return row;
    }

    public void remove() {
        throw new UnsupportedOperationException(Bundle.getErrorString("IteratorFactory_Iterator_removeUnsupported", new Object[]{this.getClass().getName()}));
    }
}

