/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.util.iterator;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.beehive.netui.util.Bundle;
import org.apache.beehive.netui.util.logging.Logger;

public class ArrayIterator
implements Iterator {
    private static final Logger logger = Logger.getInstance(ArrayIterator.class);
    private Object _array;
    private int _totalElements;
    private int _currentElement;

    public ArrayIterator(Object array) {
        if (array != null) {
            if (!array.getClass().isArray()) {
                throw new IllegalStateException(Bundle.getErrorString("ArrayIterator_notAnArray"));
            }
            this._array = array;
            this._totalElements = Array.getLength(this._array);
        }
    }

    public boolean hasNext() {
        if (this._array == null) {
            return false;
        }
        return this._currentElement < this._totalElements;
    }

    public Object next() {
        if (logger.isDebugEnabled()) {
            logger.debug("Current element: " + this._currentElement);
            logger.debug("Total elements: " + this._totalElements);
        }
        if (this._currentElement >= this._totalElements) {
            throw new NoSuchElementException(Bundle.getErrorString("IteratorFactory_Iterator_noSuchElement"));
        }
        Object nextElement = null;
        try {
            nextElement = Array.get(this._array, this._currentElement);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Caught exception: " + e.getClass().getName());
            }
            throw new NoSuchElementException(Bundle.getErrorString("ArrayIterator_arrayError", new Object[]{this._array.getClass().getName()}));
        }
        ++this._currentElement;
        return nextElement;
    }

    public void remove() {
        throw new UnsupportedOperationException(Bundle.getErrorString("IteratorFactory_Iterator_removeUnsupported", new Object[]{this.getClass().getName()}));
    }
}

