/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.util.classloader;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.SecureClassLoader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.beehive.netui.util.logging.Logger;

public class BouncyClassLoader
extends SecureClassLoader {
    private static final Logger _log = Logger.getInstance(BouncyClassLoader.class);
    private ConcurrentHashMap<File, Long> _timestamps = new ConcurrentHashMap();
    private File[] _classDirs;

    public BouncyClassLoader(File[] classDirs, ClassLoader parent) {
        super(parent);
        this._classDirs = classDirs;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        Class<?> ret = this.findLoadedClass(name);
        if (ret != null) {
            return ret;
        }
        String baseName = File.separatorChar + name.replace('.', File.separatorChar).concat(".class");
        for (int i = 0; i < this._classDirs.length; ++i) {
            File file = new File(this._classDirs[i].getPath() + baseName);
            if (!file.exists()) continue;
            this._timestamps.put(file, new Long(file.lastModified()));
            byte[] bytes = this.getBytes(file);
            if (bytes == null) continue;
            return super.defineClass(name, bytes, 0, bytes.length);
        }
        return super.loadClass(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getBytes(File file) {
        block7: {
            byte[] byArray;
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            try {
                int c;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while ((c = in.read()) != -1) {
                    out.write(c);
                }
                byArray = out.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    _log.error("Could not read class file " + file, e);
                    break block7;
                }
                catch (IOException e) {
                    _log.error("Error while reading class file " + file, e);
                }
            }
            in.close();
            return byArray;
        }
        return null;
    }

    public boolean isStale() {
        for (Map.Entry<File, Long> entry : this._timestamps.entrySet()) {
            if (entry.getKey().lastModified() <= entry.getValue()) continue;
            return true;
        }
        return false;
    }
}

