/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.util.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ClassLevelCache {
    private static ConcurrentHashMap _classCaches = new ConcurrentHashMap();
    private ConcurrentHashMap _caches = new ConcurrentHashMap();

    public static ClassLevelCache getCache(Class c) {
        String className = c.getName();
        ClassLevelCache cache = (ClassLevelCache)_classCaches.get(className);
        if (cache == null) {
            cache = new ClassLevelCache();
            _classCaches.put(className, cache);
        }
        return cache;
    }

    protected ClassLevelCache() {
    }

    public Object get(String majorKey, String minorKey) {
        ConcurrentHashMap cache = (ConcurrentHashMap)this._caches.get(majorKey);
        return cache != null ? cache.get(minorKey) : null;
    }

    public Object getCacheObject(String cacheID) {
        return this._caches.get(cacheID);
    }

    public void setCacheObject(String cacheID, Object object) {
        this._caches.put(cacheID, object);
    }

    public Map getCacheMap(String cacheID) {
        return this.getCacheMap(cacheID, true);
    }

    public Map getCacheMap(String cacheID, boolean createIfMissing) {
        ConcurrentHashMap cache = (ConcurrentHashMap)this._caches.get(cacheID);
        if (cache == null && createIfMissing) {
            cache = new ConcurrentHashMap();
            this._caches.put(cacheID, cache);
        }
        return cache;
    }

    public void put(String cacheID, String minorKey, Object value) {
        assert (value != null);
        this.getCacheMap(cacheID).put(minorKey, value);
    }

    public static void clearAll() {
        _classCaches.clear();
    }
}

