/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.util;

import java.io.PrintStream;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletUtils {
    public static void dumpRequest(HttpServletRequest request, PrintStream output) {
        String name;
        if (output == null) {
            output = System.err;
        }
        output.println("*** HttpServletRequest " + request);
        output.println("        uri = " + request.getRequestURI());
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            output.println("            parameter " + name + " = " + request.getParameter(name));
        }
        e = request.getAttributeNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            output.println("            attribute " + name + " = " + request.getAttribute(name));
        }
        e = request.getSession().getAttributeNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            output.println("            session attribute " + name + " = " + request.getSession().getAttribute(name));
        }
    }

    public static void dumpServletContext(ServletContext context, PrintStream output) {
        if (output == null) {
            output = System.err;
        }
        output.println("*** ServletContext " + context);
        Enumeration e = context.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            output.println("            attribute " + name + " = " + context.getAttribute(name));
        }
    }

    public static void preventCache(HttpServletResponse response) {
        response.setHeader("Pragma", "No-cache");
        response.setDateHeader("Expires", 0L);
        response.setHeader("Cache-Control", "no-cache");
    }

    public static String getBaseName(String uri) {
        int lastSlash = uri.lastIndexOf(47);
        assert (lastSlash != -1) : uri;
        assert (lastSlash < uri.length() - 1) : "URI must not end with a slash: " + uri;
        return uri.substring(lastSlash + 1);
    }

    public static String getDirName(String uri) {
        int lastSlash = uri.lastIndexOf(47);
        assert (lastSlash != -1) : uri;
        assert (uri.length() > 1) : uri;
        assert (lastSlash < uri.length() - 1) : "URI must not end with a slash: " + uri;
        return uri.substring(0, lastSlash);
    }
}

