/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.el.ELException;

public class HtmlExceptionFormatter {
    private static final String HTML_LINE_BREAK = "<br/>";
    private static final String LINE_BREAK = "\n";
    private static final String CAUSED_BY = "caused by ";

    public static String format(String message, Throwable t, boolean includeStackTrace) {
        StringBuilder buf = new StringBuilder();
        if (message != null) {
            buf.append(message);
            Throwable cause = HtmlExceptionFormatter.discoverRootCause(t);
            if (cause != null) {
                buf.append(HTML_LINE_BREAK);
                buf.append(CAUSED_BY);
                buf.append(": ");
                buf.append(cause.toString());
            }
        }
        if (includeStackTrace) {
            if (message != null) {
                buf.append(HTML_LINE_BREAK);
            }
            String st = HtmlExceptionFormatter.addStackTrace(t);
            buf.append(st);
            Throwable rootCause = null;
            Throwable tmp = t;
            while (HtmlExceptionFormatter.hasRootCause(tmp) && (rootCause = HtmlExceptionFormatter.discoverRootCause(tmp)) != null) {
                st = HtmlExceptionFormatter.addStackTrace(rootCause);
                buf.append(HTML_LINE_BREAK);
                buf.append(st);
                tmp = rootCause;
            }
        }
        return buf.toString().replaceAll(LINE_BREAK, HTML_LINE_BREAK);
    }

    private static final String addStackTrace(Throwable t) {
        StringBuilder buf = new StringBuilder();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        pw.close();
        String error = sw.toString();
        int pos = error.indexOf(LINE_BREAK);
        if (pos != -1) {
            String lineOne = error.substring(0, pos);
            String rest = error.substring(pos);
            buf.append("<span class='pfErrorLineOne'>");
            buf.append(lineOne);
            buf.append("</span>");
            buf.append(rest);
        } else {
            buf.append(sw.toString());
        }
        return buf.toString();
    }

    private static final boolean hasRootCause(Throwable t) {
        return t.getCause() == null && (t instanceof JspException || t instanceof ServletException || t instanceof ELException);
    }

    private static final Throwable discoverRootCause(Throwable t) {
        Throwable cause = null;
        cause = t instanceof JspException ? ((JspException)t).getRootCause() : (t instanceof ServletException ? ((ServletException)t).getRootCause() : (t instanceof ELException ? ((ELException)t).getRootCause() : t.getCause()));
        return cause;
    }
}

