/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.beehive.netui.util.logging.Logger;

public class DiscoveryUtils {
    private static final Logger _log = Logger.getInstance(DiscoveryUtils.class);

    public static ClassLoader getClassLoader() {
        block4: {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl != null) {
                    return cl;
                }
            }
            catch (SecurityException e) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug("Could not get thread context classloader.", e);
            }
        }
        if (_log.isTraceEnabled()) {
            _log.trace("Can't use thread context classloader; using classloader for " + DiscoveryUtils.class.getName());
        }
        return DiscoveryUtils.class.getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class[] getImplementorClasses(Class interfaceType) {
        String interfaceName = interfaceType.getName();
        ArrayList<Class> classes = new ArrayList<Class>();
        ClassLoader classLoader = DiscoveryUtils.getClassLoader();
        try {
            Enumeration<URL> e = classLoader.getResources("META-INF/services/" + interfaceName);
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                if (_log.isTraceEnabled()) {
                    _log.trace("Found implementor entry for interface " + interfaceName + " at " + url);
                }
                InputStream is = null;
                String className = null;
                try {
                    is = url.openStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                    className = reader.readLine().trim();
                    Class implementorClass = DiscoveryUtils.loadImplementorClass(className, interfaceType, classLoader);
                    if (implementorClass == null) continue;
                    classes.add(implementorClass);
                }
                catch (IOException ioe) {
                    _log.error("Could not read implementor class entry at + " + url);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (IOException e) {
            _log.error("Could not discover implementors for " + interfaceName, e);
        }
        return classes.toArray(new Class[0]);
    }

    public static Object newImplementorInstance(String className, Class interfaceType) {
        Class implementorClass = DiscoveryUtils.loadImplementorClass(className, interfaceType);
        if (implementorClass != null) {
            try {
                return implementorClass.newInstance();
            }
            catch (IllegalAccessException e) {
                _log.error("Could not instantiate " + className + " for interface " + interfaceType.getName(), e);
            }
            catch (InstantiationException e) {
                _log.error("Could not instantiate " + className + " for interface " + interfaceType.getName(), e);
            }
        }
        return null;
    }

    public static Class loadImplementorClass(String className, Class interfaceType) {
        return DiscoveryUtils.loadImplementorClass(className, interfaceType, DiscoveryUtils.getClassLoader());
    }

    private static Class loadImplementorClass(String className, Class interfaceType, ClassLoader classLoader) {
        try {
            Class<?> implementorClass;
            if (_log.isDebugEnabled()) {
                _log.debug("Trying to load implementor class for interface " + interfaceType.getName() + ": " + className);
            }
            if (interfaceType.isAssignableFrom(implementorClass = classLoader.loadClass(className))) {
                return implementorClass;
            }
            _log.error("Implementor class " + className + " does not implement interface " + interfaceType.getName());
        }
        catch (ClassNotFoundException cnfe) {
            _log.error("Could not find implementor class " + className + " for interface " + interfaceType.getName(), cnfe);
        }
        catch (LinkageError le) {
            _log.error("Linkage error when loading implementor class " + className + " for interface " + interfaceType.getName(), le);
        }
        return null;
    }
}

