/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.core.urls;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.beehive.netui.core.urls.MutableURI;
import org.apache.beehive.netui.core.urls.URLRewriter;
import org.apache.beehive.netui.pageflow.scoping.ScopedServletUtils;
import org.apache.beehive.netui.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLRewriterService {
    private static final Logger _log = Logger.getInstance(URLRewriterService.class);
    private static String URL_REWRITERS_KEY = "url_rewriters";

    public static String rewriteName(ServletContext servletContext, ServletRequest request, String name) {
        ArrayList<URLRewriter> rewriters = URLRewriterService.getRewriters(request);
        if (rewriters != null) {
            for (URLRewriter rewriter : rewriters) {
                name = rewriter.rewriteName(servletContext, request, name);
            }
        }
        return name;
    }

    public static void rewriteURL(ServletContext servletContext, ServletRequest request, ServletResponse response, MutableURI url, URLRewriter.URLType type, boolean needsToBeSecure) {
        ArrayList<URLRewriter> rewriters = URLRewriterService.getRewriters(request);
        if (rewriters != null) {
            for (URLRewriter rewriter : rewriters) {
                rewriter.rewriteURL(servletContext, request, response, url, type, needsToBeSecure);
            }
        }
    }

    public static List<URLRewriter> getURLRewriters(ServletRequest request) {
        return Collections.unmodifiableList(URLRewriterService.getRewriters(request));
    }

    public static boolean registerURLRewriter(ServletRequest request, URLRewriter rewriter) {
        ArrayList<URLRewriter> rewriters = URLRewriterService.getRewriters(request);
        if (rewriters != null) {
            return URLRewriterService.addRewriter(rewriters, rewriter, rewriters.size());
        }
        rewriters = new ArrayList();
        rewriters.add(rewriter);
        request.setAttribute(URL_REWRITERS_KEY, rewriters);
        return true;
    }

    public static boolean registerURLRewriter(int index, ServletRequest request, URLRewriter rewriter) {
        ArrayList<URLRewriter> rewriters = URLRewriterService.getRewriters(request);
        if (rewriters != null) {
            return URLRewriterService.addRewriter(rewriters, rewriter, index);
        }
        rewriters = new ArrayList();
        rewriters.add(rewriter);
        request.setAttribute(URL_REWRITERS_KEY, rewriters);
        return true;
    }

    private static ArrayList<URLRewriter> getRewriters(ServletRequest request) {
        return (ArrayList)ScopedServletUtils.getScopedRequestAttribute((String)URL_REWRITERS_KEY, (ServletRequest)request);
    }

    private static boolean addRewriter(ArrayList<URLRewriter> rewriters, URLRewriter rewriter, int index) {
        if (URLRewriterService.otherRewritersAllowed(rewriters)) {
            if (!rewriters.contains(rewriter)) {
                if (!rewriter.allowOtherRewriters()) {
                    rewriters.clear();
                    if (rewriters.size() > 0 && _log.isInfoEnabled()) {
                        StringBuilder message = new StringBuilder();
                        message.append("Register exclusive URLRewriter, \"");
                        message.append(rewriter.getClass().getName());
                        message.append("\". This removes any other URLRewriter objects already registered in the chain.");
                        _log.info(message.toString());
                    }
                }
                rewriters.add(index, rewriter);
            }
        } else {
            if (_log.isInfoEnabled()) {
                StringBuilder message = new StringBuilder();
                message.append("Cannot register URLRewriter, \"");
                message.append(rewriter.getClass().getName());
                message.append("\". The URLRewriter, \"");
                message.append(rewriters.get(0).getClass().getName());
                message.append("\", is already registered and does not allow other rewriters.");
                _log.info(message.toString());
            }
            return false;
        }
        return true;
    }

    private static boolean otherRewritersAllowed(ArrayList<URLRewriter> rewriters) {
        return rewriters == null || rewriters.size() != 1 || rewriters.get(0).allowOtherRewriters();
    }

    public static void unregisterURLRewriter(ServletRequest request, URLRewriter rewriter) {
        if (rewriter == null) {
            return;
        }
        ArrayList<URLRewriter> rewriters = URLRewriterService.getRewriters(request);
        if (rewriters == null) {
            return;
        }
        rewriters.remove(rewriter);
        if (rewriters.size() == 0) {
            request.removeAttribute(URL_REWRITERS_KEY);
        }
    }

    public static void unregisterAllURLRewriters(ServletRequest request) {
        request.removeAttribute(URL_REWRITERS_KEY);
    }

    public static boolean allowParamsOnFormAction(ServletContext servletContext, ServletRequest request) {
        ArrayList<URLRewriter> rewriters = URLRewriterService.getRewriters(request);
        if (rewriters != null) {
            for (URLRewriter rewriter : rewriters) {
                if (rewriter.allowParamsOnFormAction(servletContext, request)) continue;
                return false;
            }
        }
        return true;
    }

    public static void dumpURLRewriters(ServletRequest request, PrintStream output) {
        ArrayList<URLRewriter> rewriters = URLRewriterService.getRewriters(request);
        if (output == null) {
            output = System.err;
        }
        output.println("*** List of URLRewriter objects: " + rewriters);
        if (rewriters != null) {
            int count = 0;
            for (URLRewriter rewriter : rewriters) {
                output.println("        " + count++ + ".  " + rewriter.getClass().getName());
                output.println("            allows other rewriters: " + rewriter.allowOtherRewriters());
                output.println("            rewriter: " + rewriter);
            }
        } else {
            output.println("        No URLRewriter objects are registered with this request.");
        }
    }
}

