/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.core.urls;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.beehive.netui.core.URLCodec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableURI {
    public static final int UNDEFINED_PORT = -1;
    public static final String DEFAULT_ENCODING = "UTF-8";
    private String _encoding;
    private String _scheme;
    private String _userInfo;
    private String _host;
    private int _port;
    private String _path;
    private LinkedHashMap<String, List<String>> _params;
    private String _fragment;
    private static final List<String> EMPTY_LIST = Collections.unmodifiableList(new ArrayList(0));
    private static final Map<String, List<String>> EMPTY_MAP = Collections.unmodifiableMap(new HashMap());

    public MutableURI() {
    }

    public MutableURI(String uriString) throws URISyntaxException {
        assert (uriString != null) : "The uri cannot be null.";
        if (uriString == null) {
            throw new IllegalArgumentException("The URI cannot be null.");
        }
        URI uri = new URI(uriString);
        this.setScheme(uri.getScheme());
        this.setUserInfo(uri.getRawUserInfo());
        this.setHost(uri.getHost());
        this.setPort(uri.getPort());
        this.setPath(uri.getRawPath());
        this.setQuery(uri.getRawQuery());
        this.setFragment(uri.getRawFragment());
    }

    public MutableURI(String scheme, String userInfo, String host, int port, String path, String query, String fragment) {
        this.setScheme(scheme);
        this.setUserInfo(userInfo);
        this.setHost(host);
        this.setPort(port);
        this.setPath(path);
        this.setQuery(query);
        this.setFragment(fragment);
    }

    public MutableURI(URI uri) {
        assert (uri != null) : "The URI cannot be null.";
        if (uri == null) {
            throw new IllegalArgumentException("The URI cannot be null.");
        }
        this.setScheme(uri.getScheme());
        this.setUserInfo(uri.getRawUserInfo());
        this.setHost(uri.getHost());
        this.setPort(uri.getPort());
        this.setPath(uri.getRawPath());
        this.setQuery(uri.getRawQuery());
        this.setFragment(uri.getRawFragment());
    }

    public MutableURI(URL url) throws URISyntaxException {
        assert (url != null) : "The URL cannot be null.";
        if (url == null) {
            throw new IllegalArgumentException("The URL cannot be null.");
        }
        URI uri = url.toURI();
        this.setScheme(uri.getScheme());
        this.setUserInfo(uri.getRawUserInfo());
        this.setHost(uri.getHost());
        this.setPort(uri.getPort());
        this.setPath(uri.getRawPath());
        this.setQuery(uri.getRawQuery());
        this.setFragment(uri.getRawFragment());
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void setScheme(String scheme) {
        this._scheme = null;
        if (scheme != null && scheme.length() > 0) {
            this._scheme = scheme;
        }
    }

    public String getScheme() {
        return this._scheme;
    }

    public void setUserInfo(String userInfo) {
        this._userInfo = null;
        if (userInfo != null && userInfo.length() > 0) {
            this._userInfo = userInfo;
        }
    }

    public String getUserInfo() {
        return this._userInfo;
    }

    public void setHost(String host) {
        this._host = null;
        if (host != null && host.length() > 0) {
            boolean needBrackets = host.indexOf(58) >= 0 && !host.startsWith("[") && !host.endsWith("]");
            this._host = needBrackets ? '[' + host + ']' : host;
        }
        if (this._host == null) {
            this.setUserInfo(null);
            this.setPort(-1);
        }
    }

    public String getHost() {
        return this._host;
    }

    public void setPort(int port) {
        assert (port >= 0 && port <= 65535 || port == -1) : "Invalid port";
        if (port > 65535 || port < 0 && port != -1) {
            throw new IllegalArgumentException("A port must be between 0 and 65535 or equal to -1.");
        }
        this._port = port;
    }

    public int getPort() {
        return this._port;
    }

    public void setPath(String path) {
        if (path == null) {
            this._path = null;
            this.setQuery(null);
            this.setFragment(null);
        } else {
            this._path = path;
        }
    }

    public String getPath() {
        return this._path;
    }

    public void setQuery(String query) {
        this._params = null;
        if (query == null || query.length() == 0) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(query, "&");
        while (tok.hasMoreElements()) {
            String queryItem = tok.nextToken();
            int eq = queryItem.indexOf(61);
            if (eq != -1) {
                this.addParameter(queryItem.substring(0, eq), queryItem.substring(eq + 1), true);
                continue;
            }
            this.addParameter(queryItem, null, true);
        }
    }

    public String getQuery(String paramSeparator) {
        assert (paramSeparator != null);
        if (paramSeparator == null || paramSeparator.length() == 0) {
            throw new IllegalArgumentException("Parameter separator cannot be null or empty.");
        }
        if (this._params == null || this._params.isEmpty()) {
            return null;
        }
        StringBuffer query = new StringBuffer(64);
        boolean firstParam = true;
        for (String name : this._params.keySet()) {
            for (String value : this._params.get(name)) {
                if (firstParam) {
                    firstParam = false;
                } else {
                    query.append(paramSeparator);
                }
                query.append(name);
                if (value == null) continue;
                query.append('=').append(value);
            }
        }
        return query.toString();
    }

    public void addParameter(String name, String value, boolean encoded) {
        List<String> values;
        if (name == null) {
            throw new IllegalArgumentException("A parameter name may not be null.");
        }
        if (!encoded) {
            name = MutableURI.encode(name, this._encoding);
            value = MutableURI.encode(value, this._encoding);
        }
        if (this._params == null) {
            this._params = new LinkedHashMap();
        }
        if ((values = this._params.get(name)) == null) {
            values = new ArrayList<String>();
            this._params.put(name, values);
        }
        values.add(value);
    }

    public void addParameters(Map newParams, boolean encoded) {
        if (newParams == null) {
            throw new IllegalArgumentException("Cannot add null map of parameters.");
        }
        if (newParams.size() == 0) {
            return;
        }
        if (this._params == null) {
            this._params = new LinkedHashMap();
        }
        Iterator keys = newParams.keySet().iterator();
        while (keys.hasNext()) {
            Object newValues;
            Object newValue;
            List<String> values;
            String name;
            String encodedName = name = (String)keys.next();
            if (!encoded) {
                encodedName = MutableURI.encode(name, this._encoding);
            }
            if ((values = this._params.get(encodedName)) == null) {
                values = new ArrayList<String>();
                this._params.put(encodedName, values);
            }
            if ((newValue = newParams.get(name)) == null) {
                values.add(null);
                continue;
            }
            if (newValue instanceof String) {
                this.addValue(values, (String)newValue, encoded);
                continue;
            }
            if (newValue instanceof String[]) {
                newValues = (String[])newValue;
                for (int i = 0; i < ((String[])newValues).length; ++i) {
                    this.addValue(values, (String)newValues[i], encoded);
                }
                continue;
            }
            if (newValue instanceof List) {
                newValues = ((List)newValue).iterator();
                while (newValues.hasNext()) {
                    this.addValue(values, newValues.next().toString(), encoded);
                }
                continue;
            }
            this.addValue(values, newValue.toString(), encoded);
        }
    }

    private void addValue(List<String> list, String value, boolean encoded) {
        if (!encoded) {
            value = MutableURI.encode(value, this._encoding);
        }
        list.add(value);
    }

    public String getParameter(String name) {
        if (this._params == null) {
            return null;
        }
        List<String> values = this._params.get(name);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    public List<String> getParameters(String name) {
        if (this._params == null) {
            return EMPTY_LIST;
        }
        List<String> values = this._params.get(name);
        if (values == null) {
            return EMPTY_LIST;
        }
        return Collections.unmodifiableList(values);
    }

    public Map<String, List<String>> getParameters() {
        if (this._params == null) {
            return EMPTY_MAP;
        }
        return Collections.unmodifiableMap(this._params);
    }

    public void removeParameter(String name) {
        if (this._params == null) {
            return;
        }
        this._params.remove(name);
    }

    public void setFragment(String fragment) {
        this._fragment = null;
        if (fragment != null && fragment.length() > 0) {
            this._fragment = fragment;
        }
    }

    public String getFragment() {
        return this._fragment;
    }

    public boolean isAbsolute() {
        return this.getScheme() != null;
    }

    public String toString() {
        return this.toString("&");
    }

    public String toXMLString() {
        return this.toString("&amp;");
    }

    private String toString(String paramSeparator) {
        StringBuilder buf = new StringBuilder(128);
        if (this.getScheme() != null) {
            buf.append(this.getScheme()).append(':');
        }
        if (this.getHost() != null) {
            buf.append("//");
            if (this.getUserInfo() != null) {
                buf.append(this.getUserInfo());
                buf.append('@');
            }
            buf.append(this.getHost());
            if (this.getPort() != -1) {
                buf.append(':').append(this.getPort());
            }
        }
        if (this.getPath() != null) {
            if (this.isAbsolute()) {
                MutableURI.appendEnsureSeparator(buf, this.getPath());
            } else {
                buf.append(this.getPath());
            }
        }
        if (this._params != null && this._params.size() > 0) {
            buf.append('?');
            buf.append(this.getQuery(paramSeparator));
        }
        if (this.getFragment() != null && this.getFragment().length() > 0) {
            buf.append('#').append(this.getFragment());
        }
        String url = buf.toString();
        return url;
    }

    private static void appendEnsureSeparator(StringBuilder buf, String token) {
        if (token != null && token.length() > 0) {
            if (buf.charAt(buf.length() - 1) != '/' && token.charAt(0) != '/') {
                buf.append('/');
            }
            if (buf.charAt(buf.length() - 1) == '/' && token.charAt(0) == '/') {
                token = token.substring(1);
            }
            buf.append(token);
        }
    }

    public static String encode(String url, String encoding) {
        String encodedURL = null;
        try {
            encodedURL = URLCodec.encode(url, encoding);
        }
        catch (UnsupportedEncodingException e) {
            try {
                encodedURL = URLCodec.encode(url, DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException ignore) {
                // empty catch block
            }
        }
        return encodedURL;
    }

    public boolean equals(Object object) {
        Map<String, List<String>> testParams;
        Map<String, List<String>> params;
        if (object == this) {
            return true;
        }
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        MutableURI testURI = (MutableURI)object;
        return (this._scheme == testURI.getScheme() || this._scheme != null && this._scheme.equalsIgnoreCase(testURI.getScheme())) && (this._userInfo == testURI.getUserInfo() || this._userInfo != null && this._userInfo.equals(testURI.getUserInfo())) && (this._host == testURI.getHost() || this._host != null && this._host.equalsIgnoreCase(testURI.getHost())) && this._port == testURI.getPort() && (this._path == testURI.getPath() || this._path != null && this._path.equals(testURI.getPath())) && (this._fragment == testURI.getFragment() || this._fragment != null && this._fragment.equals(testURI.getFragment())) && (this._encoding == testURI.getEncoding() || this._encoding != null && this._encoding.equals(testURI.getEncoding())) && ((params = this.getParameters()) == (testParams = testURI.getParameters()) || params != null && ((Object)params).equals(testParams));
    }

    public int hashCode() {
        return 0;
    }
}

