/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow.scoping.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.beehive.netui.pageflow.scoping.ScopedResponse;
import org.apache.log4j.Logger;

public class ScopedResponseImpl
extends HttpServletResponseWrapper
implements ScopedResponse {
    private boolean _isError = false;
    private int _statusCode = -1;
    private String _redirectURI = null;
    private String _statusMessage = null;
    private HashMap _headers = new HashMap();
    private static final String SET_COOKIE = "Set-Cookie";
    private static final Logger logger = Logger.getLogger(ScopedResponseImpl.class);

    public ScopedResponseImpl(HttpServletResponse response) {
        super(response);
    }

    public void sendError(int i, String s) throws IOException {
        this._isError = true;
        this._statusCode = i;
        this._statusMessage = s;
        if (logger.isInfoEnabled()) {
            StringBuffer msg = new StringBuffer("ScopedResponse error ").append(i);
            logger.info((Object)msg.append(": ").append(s));
        }
    }

    public void sendError(int i) throws IOException {
        this.sendError(i, "");
    }

    public void setStatus(int i) {
        this.setStatus(i, "");
    }

    public void setStatus(int i, String s) {
        this._statusCode = i;
        this._statusMessage = s;
    }

    public void setContentLength(int i) {
    }

    public void setContentType(String s) {
    }

    public void setBufferSize(int i) {
    }

    public void flushBuffer() throws IOException {
    }

    public void resetBuffer() {
    }

    public void reset() {
    }

    public void addCookie(Cookie cookie) {
        this.addObjectHeader(SET_COOKIE, cookie);
    }

    public Cookie getCookie(String cookieName) {
        List cookies = this.getHeaders(SET_COOKIE);
        if (cookies != null) {
            int i = cookies.size();
            while (--i > -1) {
                Cookie cookie = (Cookie)cookies.get(i);
                if (!cookie.getName().equals(cookieName)) continue;
                return cookie;
            }
        }
        return null;
    }

    public Cookie[] getCookies() {
        List cookies = (List)this._headers.get(SET_COOKIE);
        return cookies != null ? cookies.toArray(new Cookie[0]) : new Cookie[]{};
    }

    public boolean containsHeader(String name) {
        return this._headers.containsKey(name);
    }

    public void setDateHeader(String name, long date) {
        this.setObjectHeader(name, new Date(date));
    }

    public void addDateHeader(String name, long date) {
        this.addObjectHeader(name, new Date(date));
    }

    public void setHeader(String name, String value) {
        this.setObjectHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this.addObjectHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.setObjectHeader(name, new Integer(value));
    }

    public void addIntHeader(String name, int value) {
        this.addObjectHeader(name, new Integer(value));
    }

    public Map getHeaders() {
        return this._headers;
    }

    public List getHeaders(String name) {
        return (List)this._headers.get(name);
    }

    public Object getFirstHeader(String name) {
        List foundHeaders = (List)this._headers.get(name);
        return !foundHeaders.isEmpty() ? foundHeaders.get(0) : null;
    }

    protected void addObjectHeader(String name, Object val) {
        ArrayList<Object> vals = (ArrayList<Object>)this._headers.get(name);
        if (vals == null) {
            vals = new ArrayList<Object>();
            this._headers.put(name, vals);
        }
        vals.add(val);
    }

    protected void setObjectHeader(String name, Object val) {
        ArrayList<Object> vals = new ArrayList<Object>();
        vals.add(val);
        this._headers.put(name, vals);
    }

    public HttpServletResponse getOuterResponse() {
        return (HttpServletResponse)this.getResponse();
    }

    public boolean isError() {
        return this._isError;
    }

    public int getStatusCode() {
        return this._statusCode;
    }

    public String getStatusMessage() {
        return this._statusMessage;
    }

    public void sendRedirect(String redirectURI) throws IOException {
        this._redirectURI = redirectURI;
    }

    public void applyRedirect() throws IOException {
        if (this._redirectURI == null) {
            throw new IllegalStateException("No redirect to apply.");
        }
        super.sendRedirect(this._redirectURI);
    }

    public boolean didRedirect() {
        return this._redirectURI != null;
    }

    public String getRedirectURI() {
        return this._redirectURI;
    }
}

