/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow.scoping.internal;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.beehive.netui.pageflow.scoping.ScopedRequest;
import org.apache.beehive.netui.pageflow.scoping.ScopedServletUtils;
import org.apache.beehive.netui.pageflow.scoping.internal.ParseUtils;
import org.apache.beehive.netui.pageflow.scoping.internal.ScopedAttributeContainer;
import org.apache.beehive.netui.pageflow.scoping.internal.ScopedRequestDispatcher;
import org.apache.log4j.Logger;

public class ScopedRequestImpl
extends HttpServletRequestWrapper
implements ScopedRequest {
    private String _requestURI;
    private String _servletPath;
    private String _forwardedURI;
    private ScopedAttributeContainer _scopedContainer;
    private List _listenScopes;
    private String _overridePathInfo = null;
    private boolean _isActiveRequest = false;
    private boolean _seeOuterRequestAttributes = false;
    private Set _visibleOuterRequestAttrs;
    private Map _additionalParameters;
    static final String ATTR_PREFIX = "_netui:";
    private static final String OUR_SESSION_ATTR = "_netui:scopedSession";
    private static final String STORED_ATTRS_ATTR = "_netui:storedAttrs";
    private static final Logger logger = Logger.getLogger(ScopedRequestImpl.class);

    public ScopedRequestImpl(HttpServletRequest req, String overrideRequestURI, Object scopeKey, ServletContext servletContext, boolean seeOuterRequestAttributes) {
        super(req);
        this._scopedContainer = new ScopedAttributeContainer(scopeKey);
        this.setRequestURI(overrideRequestURI);
        this._seeOuterRequestAttributes = seeOuterRequestAttributes;
        if (!seeOuterRequestAttributes) {
            this._visibleOuterRequestAttrs = new HashSet();
        }
    }

    public ScopedRequestImpl(HttpServletRequest req, String overrideRequestURI, Object scopeKey, ServletContext context) {
        this(req, overrideRequestURI, scopeKey, context, false);
    }

    public String getRequestedSessionId() {
        return super.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this._requestURI;
    }

    public void setRequestURI(String uri) {
        this._requestURI = uri;
        if (uri == null) {
            this._servletPath = null;
            return;
        }
        assert (uri.startsWith(this.getOuterRequest().getContextPath())) : uri;
        this.setServletPath(uri.substring(this.getOuterRequest().getContextPath().length()));
    }

    public void setRequestURI(String contextPath, String servletPath) {
        this._requestURI = contextPath + servletPath;
        this.setServletPath(servletPath);
    }

    private void setServletPath(String servletPath) {
        String encoding = this.getCharacterEncoding();
        try {
            if (encoding == null) {
                encoding = "utf-8";
            }
            servletPath = URLDecoder.decode(servletPath, encoding);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("unsupported encoding " + encoding + " in request " + this._requestURI), (Throwable)e);
        }
        this._servletPath = ScopedServletUtils.normalizeURI(servletPath);
    }

    public StringBuffer getRequestURL() {
        HttpServletRequest outerRequest = this.getOuterRequest();
        StringBuffer url = new StringBuffer(outerRequest.getScheme());
        url.append("://").append(outerRequest.getServerName());
        url.append(':').append(outerRequest.getServerPort());
        url.append(this.getRequestURI());
        return url;
    }

    public String getServletPath() {
        return this._servletPath;
    }

    public String getParameter(String paramName) {
        String retVal = this.getLocalParameter(paramName);
        if (retVal == null) {
            retVal = this.getListenScopeParameter(paramName);
        }
        return retVal;
    }

    public void addParameter(String name, String value) {
        if (this._additionalParameters == null) {
            this._additionalParameters = new HashMap();
        }
        this._additionalParameters.put(name, value);
    }

    public String getLocalParameter(String paramName) {
        String overrideParam;
        if (this._additionalParameters != null && (overrideParam = (String)this._additionalParameters.get(paramName)) != null) {
            return overrideParam;
        }
        ServletRequest request = this.getRequest();
        String retVal = request.getParameter(this._scopedContainer.getScopedName(paramName));
        if (retVal == null && this._isActiveRequest && paramName.startsWith("_autoscope_")) {
            retVal = request.getParameter(paramName);
        }
        return retVal;
    }

    public String getListenScopeParameter(String paramName) {
        String retVal = null;
        if (this._listenScopes != null) {
            int len = this._listenScopes.size();
            for (int i = 0; retVal == null && i < len; ++i) {
                String key = ScopedServletUtils.getScopedName(paramName, this._listenScopes.get(i));
                retVal = this.getRequest().getParameter(key);
            }
        }
        return retVal;
    }

    public Enumeration getParameterNames() {
        ArrayList<String> paramNames = new ArrayList<String>();
        Enumeration e = this.getRequest().getParameterNames();
        while (e.hasMoreElements()) {
            String scopedParamName = (String)e.nextElement();
            if (this._scopedContainer.isInScope(scopedParamName)) {
                paramNames.add(this._scopedContainer.removeScope(scopedParamName));
                continue;
            }
            if (this._isActiveRequest && scopedParamName.startsWith("_autoscope_")) {
                paramNames.add(scopedParamName);
                continue;
            }
            if (this._listenScopes == null) continue;
            int len = this._listenScopes.size();
            for (int i = 0; i < len; ++i) {
                Object scope = this._listenScopes.get(i);
                if (!ScopedAttributeContainer.isInScope(scopedParamName, scope)) continue;
                paramNames.add(ScopedAttributeContainer.removeScope(scopedParamName, scope));
            }
        }
        return Collections.enumeration(paramNames);
    }

    public String[] getParameterValues(String paramName) {
        ServletRequest request = this.getRequest();
        String[] retVals = request.getParameterValues(this._scopedContainer.getScopedName(paramName));
        if (retVals == null && this._isActiveRequest && paramName.startsWith("_autoscope_")) {
            retVals = request.getParameterValues(paramName);
        }
        if (retVals == null && this._listenScopes != null) {
            int len = this._listenScopes.size();
            for (int i = 0; retVals == null && i < len; ++i) {
                String key = ScopedServletUtils.getScopedName(paramName, this._listenScopes.get(i));
                retVals = request.getParameterValues(key);
            }
        }
        return retVals;
    }

    public Map getParameterMap() {
        return this.filterParameterMap(this.getRequest().getParameterMap());
    }

    public Map filterParameterMap(Map parameterMap) {
        HashMap map = new HashMap();
        for (Map.Entry entry : parameterMap.entrySet()) {
            String scopedParamName = (String)entry.getKey();
            if (this._scopedContainer.isInScope(scopedParamName)) {
                map.put(this._scopedContainer.removeScope(scopedParamName), entry.getValue());
                continue;
            }
            if (this._isActiveRequest && scopedParamName.startsWith("_autoscope_")) {
                map.put(scopedParamName, entry.getValue());
                continue;
            }
            if (this._listenScopes == null) continue;
            int len = this._listenScopes.size();
            for (int j = 0; j < len; ++j) {
                if (!ScopedAttributeContainer.isInScope(scopedParamName, this._listenScopes.get(j))) continue;
                map.put(ScopedAttributeContainer.removeScope(scopedParamName, this._listenScopes.get(j)), entry.getValue());
            }
        }
        return map;
    }

    public void addListenScope(Object scopeKey) {
        assert (scopeKey != null);
        if (this._listenScopes == null) {
            this._listenScopes = new ArrayList();
        }
        this._listenScopes.add(scopeKey);
    }

    public RequestDispatcher getRequestDispatcher(String uri) {
        return new ScopedRequestDispatcher(uri);
    }

    public void doForward() {
        String forwardedURI = this._forwardedURI;
        if (forwardedURI != null) {
            if (!forwardedURI.startsWith("/")) {
                int lastSlash = this._requestURI.lastIndexOf(47);
                assert (lastSlash != -1) : this._requestURI;
                this.setRequestURI(this._requestURI.substring(0, lastSlash + 1) + forwardedURI);
            } else {
                this.setRequestURI(this.getOuterRequest().getContextPath(), forwardedURI);
            }
            this.parseQueryParameters();
        } else {
            this.setRequestURI(null);
        }
    }

    private void parseQueryParameters() {
        int queryIndex = this._requestURI.indexOf("?");
        if (queryIndex < 0) {
            return;
        }
        String queryString = this._requestURI.substring(queryIndex + 1);
        this._requestURI = this._requestURI.substring(0, queryIndex);
        if (queryString.length() == 0) {
            return;
        }
        HashMap queryParameters = new HashMap();
        ParseUtils.parseQueryString(queryString, queryParameters, this.getCharacterEncoding());
        for (Object key : queryParameters.keySet()) {
            this.addParameter((String)key, (String)queryParameters.get(key));
        }
    }

    public void setForwardedURI(String uri) {
        this._forwardedURI = uri;
    }

    public String getForwardedURI() {
        return this._forwardedURI;
    }

    public boolean didRedirect() {
        return false;
    }

    public void persistAttributes() {
        String attrName = this.getScopedName(STORED_ATTRS_ATTR);
        this.getSession().setAttribute(attrName, (Object)this._scopedContainer.getSerializableAttrs());
    }

    public void restoreAttributes() {
        String attrName = this.getScopedName(STORED_ATTRS_ATTR);
        Map savedAttrs = (Map)this.getSession().getAttribute(attrName);
        Map currentAttrs = this._scopedContainer.getAttrMap();
        if (savedAttrs != null) {
            if (currentAttrs != null) {
                savedAttrs.putAll(currentAttrs);
            }
            this._scopedContainer.setAttrMap(savedAttrs);
        }
    }

    public final HttpServletRequest getOuterRequest() {
        return (HttpServletRequest)this.getRequest();
    }

    public final Object getAttribute(String attrName) {
        return this.getAttribute(attrName, true);
    }

    public final Object getAttribute(String attrName, boolean allowOuterRequestAttributes) {
        if (!allowOuterRequestAttributes) {
            return this._scopedContainer.getAttribute(attrName);
        }
        ServletRequest outerRequest = this.getRequest();
        if (!this._seeOuterRequestAttributes && this._visibleOuterRequestAttrs.contains(attrName)) {
            return outerRequest.getAttribute(attrName);
        }
        Object value = this._scopedContainer.getAttribute(attrName);
        if (value == null && this._seeOuterRequestAttributes) {
            value = outerRequest.getAttribute(attrName);
        }
        return value;
    }

    public final void setAttribute(String attrName, Object o) {
        if (!this._seeOuterRequestAttributes && this._visibleOuterRequestAttrs.contains(attrName)) {
            this.getRequest().setAttribute(attrName, o);
        } else {
            this._scopedContainer.setAttribute(attrName, o);
        }
    }

    public final Enumeration getAttributeNames() {
        Enumeration e;
        HashSet set = new HashSet();
        if (!this._seeOuterRequestAttributes) {
            e = this.getRequest().getAttributeNames();
            while (e.hasMoreElements()) {
                Object attrName = e.nextElement();
                if (!this._visibleOuterRequestAttrs.contains(attrName)) continue;
                set.add(attrName);
            }
        }
        e = this._scopedContainer.getAttributeNames();
        while (e.hasMoreElements()) {
            set.add(e.nextElement());
        }
        if (this._seeOuterRequestAttributes) {
            e = this.getRequest().getAttributeNames();
            while (e.hasMoreElements()) {
                set.add(e.nextElement());
            }
        }
        return Collections.enumeration(set);
    }

    public final void removeAttribute(String attrName) {
        if (!this._seeOuterRequestAttributes && this._visibleOuterRequestAttrs.contains(attrName)) {
            this.getRequest().removeAttribute(attrName);
        } else {
            this._scopedContainer.removeAttribute(attrName);
        }
    }

    public void registerOuterAttribute(String attrName) {
        assert (!this._seeOuterRequestAttributes) : "(attribute " + attrName + ") " + "this method is not valid unless the ScopedRequest is configured not to see outer request attributes";
        this._visibleOuterRequestAttrs.add(attrName);
    }

    public final Object getScopeKey() {
        return this._scopedContainer.getScopeKey();
    }

    public void renameScope(Object newScopeKey) {
        this._scopedContainer.renameScope(newScopeKey);
    }

    public static void renameSessionScope(Object oldScopeKey, Object newScopeKey, HttpServletRequest outerRequest) {
        HttpSession realSession = outerRequest.getSession(false);
        if (realSession != null) {
            String realSessionAttr = ScopedServletUtils.getScopedName(OUR_SESSION_ATTR, oldScopeKey);
            Object ourSession = realSession.getAttribute(realSessionAttr);
            realSessionAttr = ScopedServletUtils.getScopedName(OUR_SESSION_ATTR, newScopeKey);
            realSession.setAttribute(realSessionAttr, ourSession);
        }
    }

    public String getPathInfo() {
        return this._overridePathInfo;
    }

    public void setPathInfo(String pathInfo) {
        this._overridePathInfo = pathInfo;
    }

    public void setActiveRequest() {
        this._isActiveRequest = true;
    }

    public final String getScopedName(String baseName) {
        return this._scopedContainer.getScopedName(baseName);
    }

    public boolean hasListenScopes() {
        return this._listenScopes != null && this._listenScopes.size() > 0;
    }
}

