/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow.scoping.internal;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.StringTokenizer;

class ParseUtils {
    private static final String WLS_DEFAULT_ENCODING = "ISO-8859-1";

    ParseUtils() {
    }

    public static void parseQueryString(String str, Map res, String encoding) {
        int i = str.indexOf(35);
        if (i > 0) {
            str = str.substring(0, i);
        }
        StringTokenizer st = new StringTokenizer(str.replace('+', ' '), "&");
        while (st.hasMoreTokens()) {
            String qp = st.nextToken();
            String[] pair = qp.split("=");
            res.put(ParseUtils.unescape(pair[0], encoding), ParseUtils.unescape(pair[1], encoding));
        }
    }

    private static String unescape(String str, String encoding) {
        if (str.indexOf(37) < 0) {
            return str;
        }
        if (encoding == null || encoding.length() == 0) {
            encoding = WLS_DEFAULT_ENCODING;
        }
        int out = 0;
        byte[] strbytes = str.getBytes();
        int len = strbytes.length;
        boolean foundNonAscii = false;
        int in = 0;
        while (in < len) {
            if (strbytes[in] == 37 && in + 2 < len && Hex.isHexChar(strbytes[in + 1]) && Hex.isHexChar(strbytes[in + 2])) {
                strbytes[out] = (byte)((Hex.hexValueOf(strbytes[in + 1]) << 4) + (Hex.hexValueOf(strbytes[in + 2]) << 0));
                in += 2;
            } else {
                if (!(foundNonAscii || strbytes[in] > 31 && strbytes[in] != 127)) {
                    encoding = System.getProperty("file.encoding");
                    foundNonAscii = true;
                }
                strbytes[out] = strbytes[in];
            }
            ++in;
            ++out;
        }
        return ParseUtils.newString(strbytes, 0, out, encoding);
    }

    private static String newString(byte[] b, int offset, int length, String enc) {
        if (ParseUtils.is8BitUnicodeSubset(enc)) {
            return ParseUtils.getString(b, offset, length);
        }
        try {
            return new String(b, offset, length, enc);
        }
        catch (UnsupportedEncodingException uee) {
            return ParseUtils.getString(b, offset, length);
        }
    }

    private static boolean is8BitUnicodeSubset(String enc) {
        return enc == null || WLS_DEFAULT_ENCODING.equalsIgnoreCase(enc) || "ISO8859_1".equalsIgnoreCase(enc) || "ASCII".equalsIgnoreCase(enc);
    }

    private static String getString(byte[] b, int offset, int length) {
        try {
            return new String(b, offset, length, WLS_DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException uee) {
            throw new AssertionError((Object)uee);
        }
    }

    static class Hex {
        private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        private static final int COLS_PER_ROW = 8;
        private static final int BYTES_PER_ROW = 16;

        private Hex() {
        }

        public static String asHex(byte[] barray, int len) {
            return Hex.asHex(barray, len, true);
        }

        public static String asUnicode(String s) {
            String unicode = "";
            for (int i = 0; i < s.length(); ++i) {
                unicode = unicode + "\\u" + Hex.asHex(s.charAt(i) >> 8) + Hex.asHex(s.charAt(i));
            }
            return unicode;
        }

        public static String asUnicode(char c) {
            StringBuffer sb = new StringBuffer();
            sb.append("\\u");
            sb.append(Hex.asHex(c >> 8) + Hex.asHex(c));
            return sb.toString();
        }

        public static String asHex(String s, String encoding) throws UnsupportedEncodingException {
            byte[] b = s.getBytes(encoding);
            return Hex.asHex(b);
        }

        public static byte[] asHexBytes(byte[] barray, int len, boolean prefix) {
            byte[] buf;
            int loopLen = Math.min(len, barray.length);
            int j = 0;
            if (prefix) {
                buf = new byte[loopLen * 2 + 2];
                buf[0] = 48;
                buf[1] = 120;
                j += 2;
            } else {
                buf = new byte[loopLen * 2];
            }
            for (int i = 0; i < loopLen; ++i) {
                buf[j++] = (byte)HEX_CHARS[(barray[i] & 0xF0) >> 4];
                buf[j++] = (byte)HEX_CHARS[(barray[i] & 0xF) >> 0];
            }
            return buf;
        }

        public static String asHex(byte[] barray, int len, boolean prefix) {
            return new String(Hex.asHexBytes(barray, len, prefix), 0);
        }

        public static byte[] fromHexString(byte[] barray, int len) {
            int i = 0;
            if (barray[0] == 48 && (barray[1] == 120 || barray[1] == 88)) {
                i += 2;
                len -= 2;
            }
            int outlen = len / 2;
            byte[] out = new byte[outlen];
            int j = 0;
            while (j < outlen) {
                out[j] = (byte)((Hex.hexValueOf(barray[i]) << 4 | Hex.hexValueOf(barray[i + 1])) & 0xFF);
                ++j;
                i += 2;
            }
            return out;
        }

        public static String asHex(int b) {
            char[] buf = new char[]{HEX_CHARS[(b & 0xF0) >> 4], HEX_CHARS[(b & 0xF) >> 0]};
            return new String(buf);
        }

        public static String asHex(byte[] barray) {
            return Hex.asHex(barray, barray.length);
        }

        public static int hexValueOf(int c) {
            if (c >= 48 && c <= 57) {
                return c - 48;
            }
            if (c >= 97 && c <= 102) {
                return c - 97 + 10;
            }
            if (c >= 65 && c <= 70) {
                return c - 65 + 10;
            }
            return 0;
        }

        public static String dump(byte[] bytes) {
            if (bytes == null) {
                return "" + bytes;
            }
            return Hex.dump(bytes, 0, bytes.length);
        }

        public static String dump(byte[] bytes, int offset, int len) {
            if (offset < 0) {
                offset = 0;
            }
            int end = Math.min(bytes.length, offset + len);
            int displayStart = offset & 0xFFFFFFF0;
            int displayEnd = end + 15 & 0xFFFFFFF0;
            StringBuffer out = new StringBuffer();
            int rowStart = displayStart;
            for (int i = displayStart; i < displayEnd; ++i) {
                if (i % 16 == 0) {
                    Hex.lineLabel(out, i);
                    rowStart = i;
                }
                if (i < offset || i >= end) {
                    out.append("  ");
                } else {
                    out.append(Hex.asHex(bytes[i]));
                }
                if (i % 2 == 1) {
                    out.append(' ');
                }
                if (i % 16 != 15) continue;
                out.append("  ");
                for (int j = rowStart; j < rowStart + 16; ++j) {
                    if (j < offset || j >= end) {
                        out.append(' ');
                        continue;
                    }
                    out.append(Hex.toPrint(bytes[j]));
                }
                out.append('\n');
            }
            return out.toString();
        }

        public static final boolean isHexChar(int c) {
            switch (c) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    return true;
                }
            }
            return false;
        }

        private static char toPrint(byte b) {
            byte i = b;
            if (i < 32 || i > 126) {
                return '.';
            }
            return (char)i;
        }

        private static void lineLabel(StringBuffer out, int i) {
            StringBuffer sb;
            String istring = new Integer(i).toString();
            if (istring.length() <= 5) {
                sb = new StringBuffer("    ");
                sb.insert(5 - istring.length(), istring);
                sb.setLength(5);
            } else {
                sb = new StringBuffer(istring);
            }
            out.append(sb);
            out.append(": ");
        }
    }
}

