/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow.scoping.internal;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class AttributeContainer {
    private static final Logger logger = Logger.getLogger(AttributeContainer.class);
    private Map _attrs;

    public Object getAttribute(String attrName) {
        return this._attrs != null ? this._attrs.get(attrName) : null;
    }

    public void setAttribute(String attrName, Object o) {
        if (this._attrs == null) {
            this._attrs = new HashMap();
        }
        this._attrs.put(attrName, o);
    }

    public Enumeration getAttributeNames() {
        if (this._attrs == null) {
            this._attrs = new HashMap();
        }
        return Collections.enumeration(this._attrs.keySet());
    }

    public String[] getAttributeNamesArray() {
        if (this._attrs == null) {
            return new String[0];
        }
        return this._attrs.keySet().toArray(new String[0]);
    }

    public void removeAttribute(String attrName) {
        if (this._attrs != null) {
            this._attrs.remove(attrName);
        }
    }

    public void removeAllAttributes() {
        this._attrs = null;
    }

    protected final Map getSerializableAttrs() {
        HashMap ret = new HashMap();
        for (Map.Entry entry : this._attrs.entrySet()) {
            if (entry.getValue() instanceof Serializable) {
                ret.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!logger.isEnabledFor(Priority.INFO)) continue;
            logger.info((Object)("Dropping non-serializable request attribute " + entry.getKey() + " (" + entry.getValue() + ")."));
        }
        return ret;
    }

    protected final Map getAttrMap() {
        return this._attrs;
    }

    protected final void setAttrMap(Map attrs) {
        this._attrs = attrs;
    }
}

