/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.pageflow.scoping;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.beehive.netui.pageflow.scoping.ScopedRequest;
import org.apache.beehive.netui.pageflow.scoping.ScopedResponse;
import org.apache.beehive.netui.pageflow.scoping.internal.ScopedRequestImpl;
import org.apache.beehive.netui.pageflow.scoping.internal.ScopedResponseImpl;
import org.apache.log4j.Logger;

public class ScopedServletUtils {
    public static final String SCOPE_ID_PARAM = "jpfScopeID";
    static final String ATTR_PREFIX = "_netui:";
    private static final String OVERRIDE_REQUEST_ATTR = "_netui:overrideRequest";
    private static final String OVERRIDE_RESPONSE_ATTR = "_netui:overrideResponse";
    private static final Logger logger = Logger.getLogger(ScopedServletUtils.class);

    public static ScopedRequest getScopedRequest(HttpServletRequest realRequest, String overrideURI, ServletContext servletContext, Object scopeKey) {
        return ScopedServletUtils.getScopedRequest(realRequest, overrideURI, servletContext, scopeKey, false);
    }

    public static ScopedRequest getScopedRequest(HttpServletRequest realRequest, String overrideURI, ServletContext servletContext, Object scopeKey, boolean seeOuterRequestAttributes) {
        assert (!(realRequest instanceof ScopedRequest));
        String requestAttr = ScopedServletUtils.getScopedName(OVERRIDE_REQUEST_ATTR, scopeKey);
        ScopedRequest scopedRequest = (ScopedRequest)realRequest.getAttribute(requestAttr);
        if (scopedRequest == null) {
            if (overrideURI != null && !overrideURI.startsWith("/")) {
                overrideURI = "/" + overrideURI;
            }
            scopedRequest = new ScopedRequestImpl(realRequest, overrideURI, scopeKey, servletContext, seeOuterRequestAttributes);
            realRequest.setAttribute(requestAttr, (Object)scopedRequest);
        }
        return scopedRequest;
    }

    public static ScopedResponse getScopedResponse(HttpServletResponse realResponse, ScopedRequest scopedRequest) {
        assert (!(realResponse instanceof ScopedResponse));
        String responseAttr = ScopedServletUtils.getScopedName(OVERRIDE_RESPONSE_ATTR, scopedRequest.getScopeKey());
        HttpServletRequest outerRequest = scopedRequest.getOuterRequest();
        ScopedResponse scopedResponse = (ScopedResponse)outerRequest.getAttribute(responseAttr);
        if (scopedResponse == null) {
            scopedResponse = new ScopedResponseImpl(realResponse);
            outerRequest.setAttribute(responseAttr, (Object)scopedResponse);
        }
        return scopedResponse;
    }

    public static void renameScope(Object oldScopeKey, Object newScopeKey, HttpServletRequest request) {
        assert (!(request instanceof ScopedRequest));
        String requestAttr = ScopedServletUtils.getScopedName(OVERRIDE_REQUEST_ATTR, oldScopeKey);
        String responseAttr = ScopedServletUtils.getScopedName(OVERRIDE_RESPONSE_ATTR, oldScopeKey);
        ScopedRequest scopedRequest = (ScopedRequest)request.getAttribute(requestAttr);
        ScopedResponse scopedResponse = (ScopedResponse)request.getAttribute(responseAttr);
        if (scopedRequest != null) {
            scopedRequest.renameScope(newScopeKey);
            request.removeAttribute(requestAttr);
            requestAttr = ScopedServletUtils.getScopedName(OVERRIDE_REQUEST_ATTR, newScopeKey);
            request.setAttribute(requestAttr, (Object)scopedRequest);
        } else {
            ScopedRequestImpl.renameSessionScope(oldScopeKey, newScopeKey, request);
        }
        if (scopedResponse != null) {
            request.removeAttribute(responseAttr);
            responseAttr = ScopedServletUtils.getScopedName(OVERRIDE_RESPONSE_ATTR, newScopeKey);
            request.setAttribute(responseAttr, (Object)scopedResponse);
        }
    }

    public static String getScopedName(String baseName, Object scopeKey) {
        return scopeKey + baseName;
    }

    public static HttpServletRequest getOuterRequest(HttpServletRequest request) {
        ScopedRequest scopedRequest = ScopedServletUtils.unwrapRequest((ServletRequest)request);
        return scopedRequest != null ? scopedRequest.getOuterRequest() : request;
    }

    public static ScopedRequest unwrapRequest(ServletRequest request) {
        while (request instanceof ServletRequestWrapper) {
            if (request instanceof ScopedRequest) {
                return (ScopedRequest)request;
            }
            request = ((ServletRequestWrapper)request).getRequest();
        }
        return null;
    }

    public static ScopedResponse unwrapResponse(ServletResponse response) {
        while (response instanceof ServletResponseWrapper) {
            if (response instanceof ScopedResponse) {
                return (ScopedResponse)response;
            }
            response = ((ServletResponseWrapper)response).getResponse();
        }
        return null;
    }

    public static String getScopedSessionAttrName(String attrName, HttpServletRequest request) {
        String requestScopeParam = request.getParameter(SCOPE_ID_PARAM);
        if (requestScopeParam != null) {
            return ScopedServletUtils.getScopedName(attrName, requestScopeParam);
        }
        ScopedRequest scopedRequest = ScopedServletUtils.unwrapRequest((ServletRequest)request);
        return scopedRequest != null ? scopedRequest.getScopedName(attrName) : attrName;
    }

    public static Object getScopedSessionAttr(String attrName, HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            return session.getAttribute(ScopedServletUtils.getScopedSessionAttrName(attrName, request));
        }
        return null;
    }

    public static void setScopedSessionAttr(String attrName, Object val, HttpServletRequest request) {
        request.getSession().setAttribute(ScopedServletUtils.getScopedSessionAttrName(attrName, request), val);
    }

    public static void removeScopedSessionAttr(String attrName, HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.removeAttribute(ScopedServletUtils.getScopedSessionAttrName(attrName, request));
        }
    }

    public static Object getScopedRequestAttribute(String attrName, ServletRequest request) {
        if (request instanceof ScopedRequest) {
            return ((ScopedRequest)request).getAttribute(attrName, false);
        }
        return request.getAttribute(attrName);
    }

    public static final String getRelativeURI(HttpServletRequest request) {
        return request.getServletPath();
    }

    public static final String getRelativeURI(HttpServletRequest request, String uri) {
        return ScopedServletUtils.getRelativeURI(request.getContextPath(), uri);
    }

    public static final String getRelativeURI(String contextPath, String uri) {
        String requestUrl = uri;
        int overlap = requestUrl.indexOf(contextPath + '/');
        assert (overlap != -1) : "contextPath: " + contextPath + ", uri: " + uri;
        return requestUrl.substring(overlap + contextPath.length());
    }

    public static String normalizeURI(String uri) {
        if (uri.indexOf("./") != -1) {
            try {
                uri = new URI(uri).normalize().toString();
            }
            catch (URISyntaxException e) {
                logger.error((Object)("Could not parse relative URI " + uri));
            }
        }
        return uri;
    }

    public static String decodeURI(HttpServletRequest request) {
        return request.getContextPath() + request.getServletPath();
    }
}

