/*
 * Decompiled with CFR 0.152.
 */
package consulting.omnia.util.spring;

import consulting.omnia.util.spring.CustomPropertyConfigurer;
import java.util.Properties;
import java.util.logging.Logger;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public final class SpringUtil {
    public static final String APPLICATION_CONTEXT_XML = "applicationContext.xml";
    public static final String DATA_SOURCE = "dataSource";
    private static final SpringUtil INSTANCE = new SpringUtil();
    private static final Logger LOGGER = Logger.getLogger(SpringUtil.class.getCanonicalName());

    private SpringUtil() {
    }

    public static SpringUtil getInstance() {
        LOGGER.finer(SpringUtil.class.getCanonicalName() + " instanced");
        return INSTANCE;
    }

    public ApplicationContext startApp(String applicationContextXml, Properties config) {
        this.checkAndSetApplicationContext(applicationContextXml);
        LOGGER.finest("Application Context: [" + applicationContextXml + "]");
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{applicationContextXml}, false);
        if (config == null) {
            throw new RuntimeException("No config data informed");
        }
        context.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new CustomPropertyConfigurer(config));
        try {
            context.refresh();
        }
        catch (BeanCreationException e) {
            LOGGER.severe(e.getRootCause().getMessage());
            throw new RuntimeException(e);
        }
        return context;
    }

    public ApplicationContext startApp(String applicationContextXml) {
        this.checkAndSetApplicationContext(applicationContextXml);
        LOGGER.finest("Application Context: [" + applicationContextXml + "]");
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{applicationContextXml}, true);
        return context;
    }

    private void checkAndSetApplicationContext(String applicationContextXml) {
        if (applicationContextXml == null) {
            applicationContextXml = APPLICATION_CONTEXT_XML;
        }
    }
}

