/*
 * Decompiled with CFR 0.152.
 */
package consulting.omnia.util.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

public class ReflectionUtil {
    public static Set<Field> listAllFields(Object obj, Comparator<Field> comparator) {
        Class<?> klass = obj.getClass();
        return ReflectionUtil.listAllFields(klass, comparator);
    }

    public static Set<Field> listAllFields(Class klass, Comparator<Field> comparator) {
        TreeSet<Field> result = new TreeSet<Field>(comparator);
        for (Class clazz = klass; clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : Arrays.asList(clazz.getDeclaredFields())) {
                result.add(field);
            }
        }
        return result;
    }

    public static Class<?>[] listGenericTypes(Class<?> klass) {
        ArrayList<Class> types = new ArrayList<Class>();
        for (Type _parameterizedType : klass.getGenericInterfaces()) {
            System.out.println(_parameterizedType);
            if (!(_parameterizedType instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)_parameterizedType;
            for (Type type : parameterizedType.getActualTypeArguments()) {
                if (!(type instanceof Class)) continue;
                Class classType = (Class)type;
                types.add(classType);
            }
        }
        Class[] result = new Class[types.size()];
        int index = 0;
        for (Class clazz : types) {
            result[index++] = clazz;
        }
        return result;
    }
}

