/*
 * Decompiled with CFR 0.152.
 */
package consulting.omnia.util.io.file.core;

import consulting.omnia.util.io.file.api.MultiDataWriter;
import consulting.omnia.util.io.file.api.NoSuchFileException;
import consulting.omnia.util.io.file.core.DefaultFileDataWritter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;

public class SimpleMultiFileDataWritter
implements MultiDataWriter {
    private static final ConcurrentMap<String, DefaultFileDataWritter> writters = new ConcurrentHashMap<String, DefaultFileDataWritter>();
    private static final Set<String> writtedData = new HashSet<String>();
    private static final MultiDataWriter INSTANCE = new SimpleMultiFileDataWritter();
    private static final Logger LOGGER = Logger.getLogger(SimpleMultiFileDataWritter.class.getCanonicalName());

    private SimpleMultiFileDataWritter() {
    }

    public static MultiDataWriter getInstance() {
        LOGGER.fine(SimpleMultiFileDataWritter.class.getCanonicalName() + " instanced");
        return INSTANCE;
    }

    @Override
    public void newWriter(String filename) throws NoSuchFileException {
        LOGGER.finer("New writer: [" + filename + "]");
        writters.putIfAbsent(filename, new DefaultFileDataWritter(filename));
    }

    @Override
    public boolean hasWriter(String filename) {
        LOGGER.finer("Has writer: [" + filename + "] ->" + writters.containsKey(filename));
        return writters.containsKey(filename);
    }

    @Override
    public void write(String filename, String data, boolean noDups) throws NoSuchFileException, IOException {
        DefaultFileDataWritter fileDataWritter = (DefaultFileDataWritter)writters.get(filename);
        if (fileDataWritter != null) {
            if (!noDups) {
                fileDataWritter.write(data);
                writtedData.add(data);
            } else if (!writtedData.contains(data)) {
                fileDataWritter.write(data);
                writtedData.add(data);
            } else {
                LOGGER.finest("Duplicate records is not allowed. Data: [" + data + "]");
            }
        } else {
            throw new NoSuchFileException(filename, new IllegalAccessException("Writter not yet initalized."));
        }
    }
}

