/*
 * Decompiled with CFR 0.152.
 */
package consulting.omnia.util.format;

import consulting.omnia.util.format.Padding;
import java.nio.charset.Charset;
import java.text.Normalizer;

public class StringUtil {
    private static final String LEFT_SPACE_PADDING = "%{}s";
    private static final String RIGHT_SPACE_PADDING = "%-{}s";
    private static final String LEFT_ZERO_PADDING = "%0{}d";
    public static final String UTF8 = "UTF-8";
    public static final String ISO_8859_1 = "ISO-8859-1";
    public static final String WINDOWS_1252 = "windows-1252";

    public static String padding(Object object, int size, String filler, Padding padding) {
        String result;
        String pattern;
        boolean isBlankFiler = " ".equals(filler);
        if (object instanceof Number) {
            pattern = StringUtil.getPattern(LEFT_ZERO_PADDING, size);
        } else {
            switch (padding) {
                case LEFT: {
                    pattern = StringUtil.getPattern(LEFT_SPACE_PADDING, size);
                    break;
                }
                default: {
                    pattern = StringUtil.getPattern(RIGHT_SPACE_PADDING, size);
                }
            }
        }
        Object value = filler;
        if (object != null) {
            value = object;
        }
        if ((result = String.format(pattern, value)).length() > size) {
            result = result.substring(0, size);
        }
        if (!isBlankFiler) {
            result = result.replaceAll(" ", filler);
        }
        return result;
    }

    private static String getPattern(String patternTemplate, int size) {
        return patternTemplate.replaceFirst("\\{\\}", String.valueOf(size));
    }

    public static <T> T numbers(String data, Class<T> type) {
        if (data == null) {
            return null;
        }
        String numbers = data.replaceAll("[^\\d]", "");
        if (Long.class.isAssignableFrom(type)) {
            return type.cast(Long.valueOf(numbers));
        }
        if (Integer.class.isAssignableFrom(type)) {
            return type.cast(Integer.valueOf(numbers));
        }
        throw new UnsupportedOperationException("Cannot convert [" + data + "] to [" + type.getCanonicalName() + "]");
    }

    public static boolean checkEncoding(Object data, String encoding) {
        String charsetDisplayName = Charset.defaultCharset().displayName();
        if (String.class.isAssignableFrom(data.getClass())) {
            try {
                if (encoding.equalsIgnoreCase(charsetDisplayName)) {
                    String dataAsString = (String)data;
                    new String(dataAsString.getBytes(), encoding);
                    return true;
                }
            }
            catch (Exception e) {
                System.err.println("Wrong charset [" + data + "] is not encoded as [" + encoding + "]");
            }
        }
        return false;
    }

    public static void outputMessage(String string) {
        System.out.println("-------------------------------------------------------------------");
        System.out.println(string);
        System.out.println("-------------------------------------------------------------------");
    }

    public static boolean isEmpty(String value) {
        return value == null ? true : value.isEmpty();
    }

    public static String toAsciiOnly(String value) {
        String normalized = Normalizer.normalize(value, Normalizer.Form.NFD);
        String asciiOnly = normalized.replaceAll("[^\\p{ASCII}]", "");
        return asciiOnly;
    }
}

